package com.digiwin.athena.atmc.http.restful.abt.impl;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.constant.AbtApiConstant;
import com.digiwin.athena.atmc.http.constant.AimApiConstant;
import com.digiwin.athena.atmc.http.constant.GlobalConstant;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.HttpAssistantServiceImpl;
import com.digiwin.athena.atmc.http.restful.abt.AbtService;
import com.digiwin.athena.atmc.http.restful.abt.model.NoticeAbtRepairDto;
import com.digiwin.athena.atmc.http.restful.abt.model.RefreshCardMessageDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmWaitRepairDataDto;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * AbtServiceImpl Description
 *
 * @author majianfu
 * @date 2023/4/7
 * @since
 */
@Slf4j
@Service
public class AbtServiceImpl implements AbtService {

    @Autowired
    private EnvProperties envProperties;

    @Autowired
    private HttpAssistantServiceImpl httpAssistantService;

    @Autowired
    private RestTemplate restTemplate;

    /**
     * {@inheritDoc}
     */
    @Override
    public void createRefreshCardMessageJob(RefreshCardMessageDTO refreshCardMessageDTO) {
        String url = envProperties.getAbtUri() + AbtApiConstant.REFRESH_CARD_MESSAGE_JOB_CREATE_IF_ABSENT;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        log.info("create refresh card message job{}, {}", refreshCardMessageDTO.getId(), refreshCardMessageDTO);
        Boolean success = httpAssistantService.post(new TypeReference<Boolean>() {
        }, url, headers, refreshCardMessageDTO);
        log.info("create refresh card message job{}, {}, ret{}", refreshCardMessageDTO.getId(), refreshCardMessageDTO, success);
    }
    @Override
    public void noticeRepairApcData(NoticeAbtRepairDto dto) {

        log.info("AbtServiceImpl.noticeRepairApcData{}", dto);
        String url = envProperties.getAbtUri() + AbtApiConstant.NOTICE_REPAIR_APC_DATA;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
//        headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());

        HttpEntity httpEntity = new HttpEntity(dto, headers);
        try {
            ResponseEntity<BaseResultDTO> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO>() {
            });
            if (respEntity.getStatusCode().value() != org.apache.http.HttpStatus.SC_OK || !respEntity.getBody().isOK()) {
                log.error("Failed to request abt to noticeRepairApcData ，statusCode: {}, responseBody: {}.", respEntity.getStatusCode().value(), respEntity.getBody());
            }
        } catch (Exception ex) {
            log.error("Failed to request abt to noticeRepairApcData，error: {}.", ex);
        }
    }
}
