package com.digiwin.athena.atmc.http.restful.esp.impl;

import com.digiwin.athena.atmc.http.constant.EspApiConstant;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.esp.model.EspApiDTO;
import com.digiwin.athena.atmc.http.restful.esp.ApiMetadataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@Service
public class ApiMetadataServiceImpl implements ApiMetadataService {

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    public String getApiMetadataInvokeType(String apiName){
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        Map<String,Object> paraMap=new HashMap<>();
        paraMap.put("api_name",apiName);
        String uri=envProperties.getEspUri()+ EspApiConstant.METADATA_CACHE_API_METADATA_GET;
        HttpEntity httpEntity = new HttpEntity<Map>(paraMap,headerMap);
        ResponseEntity<EspApiDTO> responseEntity = restTemplate.postForEntity(uri, httpEntity, EspApiDTO.class);
        if (responseEntity.getBody().getExecution()!=null && !"000".equals(responseEntity.getBody().getExecution().getCode())){
            return "sync";
        }

        EspApiDTO resultDTO=responseEntity.getBody();
        return resultDTO.getData().getType();
    }
}

