package com.digiwin.athena.atmc.http.restful.smartdata.impl;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.http.constant.SmartdataApiConstant;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.domain.misc.DemoCreateDTO;
import com.digiwin.athena.atmc.http.domain.misc.DemoItemResultDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmDataFootPrintDTO;
import com.digiwin.athena.atmc.http.restful.smartdata.SmartDataService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.*;

@Service
@Slf4j
public class SmartDataSerivceImpl implements SmartDataService {

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    MessageUtils messageUtils;

    /**
     * 清除指定租户的数据足迹
     * @param tenantId
     */
    public Map clearDataByTenantId(String tenantId){
        String uri = envProperties.getSdDataFootPrintUri() + SmartdataApiConstant.SERVICE_DATA_FOOTPRINT_DEV_OPS_ALL;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        Map param = new HashMap<>();
        param.put("tenantId", tenantId);

        HttpEntity<Map> httpEntity = new HttpEntity<>(param, headers);
        ResponseEntity<Map> responseEntity = restTemplate.exchange(uri, HttpMethod.DELETE, httpEntity,
                new ParameterizedTypeReference<Map>() {
                }, param);

        return responseEntity.getBody();
    }

    /**
     * 预置指定租户的数据足迹
     * @param tenantId
     */
    public Map presetDataByTenantId(String tenantId){
        String uri = envProperties.getSdDataFootPrintUri() + SmartdataApiConstant.SERVICE_DATA_FOOTPRINT_PREPARE_DATA_PRESET_DATA;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        Map param = new HashMap<>();
        param.put("tenantId", tenantId);

        HttpEntity<Map> httpEntity = new HttpEntity<>(param, headers);
        ResponseEntity<Map> responseEntity = restTemplate.exchange(uri, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<Map>() {
                }, param);

        return responseEntity.getBody();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Object clearComparisonData(AuthoredUser user, String instanceId, String activityCode, String entityName, Map<String, String> eocMap, List<Map> bkList) {
        Object result = new Object();
        String uri = envProperties.getSdDataComparisonUri() + SmartdataApiConstant.STANDARD_DATACOMPARISON_COMPARISON_V_1_STOP;

        Map<String, Object> body = new HashMap<>();
        body.put("tenantId", user.getTenantId());
        body.put("eocMap", eocMap);
        body.put("instanceId", instanceId);
        body.put("tempId", activityCode);
        body.put("bks", bkList);
        body.put("entityName", entityName);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(body, headers);
        log.info("clearComparisonData body: {}", JsonUtils.objectToString(body));
        ResponseEntity<BaseResultDTO> respEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO>() {
        });
        result = respEntity.getBody().getResponseWithException("");
        return result;
    }

    @Override
    public PtmDataFootPrintDTO queryByActTmpId(String taskCode, Map<String, Object> bk) {

        //请求地址
        String url = envProperties.getSdDataFootPrintUri() + SmartdataApiConstant.SERVICE_DATA_FOOTPRINT_ACTIVITY_QUERY_BY_ACT_TMP_ID;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //入参
        Map<String, Object> rootPara = new HashMap<>();
        rootPara.put("taskCode", taskCode);
        rootPara.put("bkInfo", bk);
        log.info("根据taskCode、bk查询数据轨迹 ，data：{}", JsonUtils.objectToString(rootPara));

        HttpEntity<?> httpEntity = new HttpEntity<>(rootPara, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<PtmDataFootPrintDTO>> responseEntity;
        try {
            responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<PtmDataFootPrintDTO>>() {
            }, rootPara);
        } catch (Exception e) {
            log.error("[atmc访问DFP 根据taskCode、bk查询数据轨迹  时出现异常(/restful/service/DataFootprint/activity/queryByActTmpId)] error:{}, stack:{}, data:{}", e, e.getStackTrace(), rootPara);
            String message = MessageFormat.format(messageUtils.getMessage("exception.ptm.smartdata.bpmdata.fail"),
                    JsonUtils.objectToString(rootPara));
            throw BusinessException.create(599, "599", message, e.getMessage(), messageUtils.getMessage("exception.ptm.smartdata.bpmdata.fail"), e);
        }

        return Objects.requireNonNull(responseEntity.getBody()).getResponse();
    }

    /**
     * 录制数据
     * @param tenantId
     * @param baseDate
     * @return
     */
    @Override
    public DemoItemResultDTO smartDataRecordData(String tenantId, String baseDate){

        DemoItemResultDTO result = new DemoItemResultDTO();
        result.setSuccess(true);
        result.setItem("SmartData 录制数据");
        result.setStartTime(LocalDateTime.now());
        result.setMessage(new ArrayList<>());
        List<String> msgList = result.getMessage();

        try {
            String uri = envProperties.getSdDataFootPrintUri() + SmartdataApiConstant.DATA_FOOTPRINT_PREPARE_DATA_INIT_DATA;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);

            Map param = new HashMap<>();
            param.put("tenantId", tenantId);
            param.put("baseDate", baseDate);

            HttpEntity<Map> httpEntity = new HttpEntity<>(param, headers);
            ResponseEntity<Map> responseEntity = restTemplate.exchange(uri, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<Map>() {
                    }, param);

            Map r = responseEntity.getBody();
            if(!r.containsKey("status") || !Objects.equals(r.get("status"), 200)){
                msgList.add("SmartData 录制数据 出现异常，详情查看日志");
                result.setSuccess(false);
                log.error("[SmartData 录制数据]", r);
            }
        }catch (Exception ex){
            result.setSuccess(false);
            msgList.add("SmartData 录制数据 出现异常，详情查看日志");
            msgList.add(ex.getMessage());
            log.error("[SmartData 录制数据]", ex);
        }

        result.setEndTime(LocalDateTime.now());
        return result;
    }

    /**
     * 删除数据
     * @return
     */
    @Override
    public DemoItemResultDTO smartDataDeleteData(String tenantId){

        DemoItemResultDTO result = new DemoItemResultDTO();
        result.setSuccess(true);
        result.setItem("SmartData 清除数据");
        result.setStartTime(LocalDateTime.now());
        result.setMessage(new ArrayList<>());
        List<String> msgList = result.getMessage();

        try {
            String uri = envProperties.getSdDataFootPrintUri() + SmartdataApiConstant.DATA_FOOTPRINT_DEV_OPS_ALL;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);

            Map param = new HashMap<>();
            param.put("tenantId", tenantId);
            param.put("secure", "");

            HttpEntity<Map> httpEntity = new HttpEntity<>(param, headers);
            ResponseEntity<Map> responseEntity = restTemplate.exchange(uri, HttpMethod.DELETE, httpEntity,
                    new ParameterizedTypeReference<Map>() {
                    }, param);

            Map m = responseEntity.getBody();
            if(!m.containsKey("status") || !Objects.equals(m.get("status"), 200)){
                msgList.add("SmartData 清除数据 出现异常，详情查看日志");
                result.setSuccess(false);
                log.error("[SmartData 清除数据]", m);
            }
        }catch (Exception ex){
            result.setSuccess(false);
            msgList.add("SmartData 清除数据 出现异常，详情查看日志");
            msgList.add(ex.getMessage());
            log.error("[SmartData 清除数据]", ex);
        }

        result.setEndTime(LocalDateTime.now());
        return result;

    }

    /**
     * 预置数据
     * @param dto
     * @return
     */
    @Override
    public DemoItemResultDTO smartDataCreateData(DemoCreateDTO dto){

        DemoItemResultDTO result = new DemoItemResultDTO();
        result.setSuccess(true);
        result.setItem("SmartData 重置数据");
        result.setStartTime(LocalDateTime.now());
        result.setMessage(new ArrayList<>());
        List<String> msgList = result.getMessage();

        try {
            String uri = envProperties.getSdDataFootPrintUri() + SmartdataApiConstant.DATA_FOOTPRINT_PREPARE_DATA_PRESET_DATA;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);

            Map param = new HashMap<>();
            param.put("sourceTenantId", dto.getSourceTenantId());
            param.put("targetTenantId", dto.getTargetTenantId());
            param.put("baseDate", dto.getBaseDate());

            HttpEntity<Map> httpEntity = new HttpEntity<>(param, headers);
            ResponseEntity<Map> responseEntity = restTemplate.exchange(uri, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<Map>() {
                    }, param);

            Map m = responseEntity.getBody();
            if(!m.containsKey("status") || !Objects.equals(m.get("status"), 200)){
                msgList.add("SmartData 重置数据 出现异常，详情查看日志");
                result.setSuccess(false);
                log.error("[SmartData 重置数据]", m);
            }
        }catch (Exception ex){
            result.setSuccess(false);
            msgList.add("SmartData 重置数据 出现异常，详情查看日志");
            msgList.add(ex.getMessage());
            log.error("[SmartData 重置数据]", ex);
        }

        result.setEndTime(LocalDateTime.now());
        return result;
    }

    @Override
    public void deleteDataComparison(String tenantId, String type, List<String> instanceIds) {

        Map<String, Object> body = new HashMap<>();
        body.put("tenantId", tenantId);
        body.put("type", type);
        body.put("instanceIds", instanceIds);
        String url = envProperties.getSdDataComparisonUri() + SmartdataApiConstant.DATA_COMPARISON_V_1_TASK_DELETE;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(body, headers);
        log.info("deleteDataComparison body: {}", JsonUtils.objectToString(body));
        this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO>(){});
    }

}
