package com.digiwin.athena.atmc.http.restful.thememap;

import cn.hutool.json.JSONObject;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.http.domain.ProjectCustomColumnRequest;
import com.digiwin.athena.atmc.http.domain.TaskCardFieldVO;
import com.digiwin.athena.atmc.http.domain.search.BaseItemDto;
import com.digiwin.athena.atmc.http.restful.thememap.model.*;
import com.digiwin.athena.atmc.http.domain.search.SearchDto;
import com.digiwin.athena.atmc.http.domain.search.SearchPojo;
import net.sf.json.JSONArray;

import java.util.List;
import java.util.Map;

public interface ThemeMapService {

    /**
     * 获取指定任务的任务定义
     *
     * @param taskId
     * @return
     */
    TmTaskDefineResponseDTO getTask(String taskId);

    /**
     * 获取指定任务的活动定义
     *
     * @param taskId
     * @return
     */
    TmActivitiesResponseDTO getActivities(String taskId, String compositionId);

    TmActivityResponseDTO getActivityAction(String tmTaskId, String tmActivityId, String pageCode);

    Map getActivityAction2(String tmTaskId, String tmActivityId, String pageCode);

    Map executeFormula(String formulaId);

    TmSolvePlanActivityDataDTO getSolvePlanActivities(String dataName, String planId);

//    JSONObject getActivityWithActivityCode(String activityCode, String pageCode);

    /**
     * 根据项目/任务code 获取挂载的报表概要信息列表
     *
     * @param bizCode
     * @param type
     * @return
     */
    List<TmReportDTO> getReportSummaryList(String bizCode, Integer type, String userId);

    /**
     * 获取报表附属的任务或者项目作业列表
     *
     * @param reportCode 报表tmActivityId
     * @param type       1：项目，2：任务
     * @return
     */
    List<TmReportDTO> getReportRelativeActivities(String reportCode, Integer type);

    /**
     * 根据项目/任务code、报表code获取报表详情信息
     *
     * @param bizCode
     * @param type
     * @param reportCode
     * @return
     */
    TmReportDTO getReportDetail(String bizCode, Integer type, String reportCode);

    /**
     * 任务引擎-查询themeMap项目所属的应用列表
     *
     * @param tmProjectId themeMap项目编号
     * @return
     */
    @Deprecated
    List<TmAppDTO> getAppsByProjectIdForTaskEngine(String tmProjectId);

    /**
     * 流程引擎-查询themeMap项目所属的应用列表
     *
     * @param tmProjectId themeMap项目编号
     * @return
     */
    List<TmAppDTO> getAppsByProjectIdForFlowEngine(String tmProjectId);

    /**
     * 获取任务的关联任务code
     *
     * @param tmTaskId
     * @param tmActivityId
     * @param pageCode
     * @return
     */
    String getActivityTargetCode(String tmTaskId, String tmActivityId, String pageCode);

    /**
     * 根据emailCode和语言别，获取邮件模板ID
     * majianfu 迭代22/需求ID：1854 2021-11-29
     *
     * @param emailCode
     * @param locale
     * @return 请求成功，则返回邮件模板ID（可能为null）；请求失败，则抛出599 BusinessException
     */
    Map getEmailEventIdByLocale(String emailCode, String locale);

    /**
     * 获取项目/任务的业务主键
     *
     * @Author：SYQ
     * @Date：2021/12/7 13:48
     */
    BusinessKeyDTO getTaskActivityBK(String objectType, String objectValue);


    /**
     *
     * @param objectType  task/activity
     * @param objectValue 项目code/任务code
     * @param user
     * @return
     */
    JSONArray getTmTaskAndActivityBk(String objectType, String objectValue, AuthoredUser user);

    /**
     * 根据 应用code 获取其包含的项目code列表
     *
     * @param appCode
     * @return
     */
    List<String> getTaskCodeListByAppCode(String appCode);

    /**
     * 批量获取项目的转派定义
     *
     * @param taskCodes 项目code列表
     * @return
     */
    List<TmTaskDefineResponseDTO> getBatchTaskAssigns(List<String> taskCodes);

    /**
     * 批量获取任务的转派定义
     *
     * @param activities map结构 {"taskCode":"task_RE_Preparation","activityCode":"purchaseApproval"}
     * @return
     */
    List<TmActivityResponseDTO> getBatchActivityAssigns(List<Map> activities);

    /**
     * 获取报表resId
     *
     * @param token
     * @param params
     * @return
     */
    Map<String, String> getReportResId(String token, Map params);

    /**
     * 获取作业inputData数据定义
     *
     * @param token
     * @param tmActivityId
     * @return
     */
    Map getActivityInputDataDefine(String token, String tmActivityId);

    /**
     * 获取过期应用的组件列表（项目、任务、基础资料录入、报表等）
     *
     * @param appExpireChangeComponent
     * @return
     */
    TmAppExpireChangeComponentDTO getAppExpireChangeComponent(TmAppExpireChangeComponentDTO appExpireChangeComponent);

    /**
     * 用appCode获取应用信息
     *
     * @param
     * @return
     */
    TmApplicationDTO getApplicationByCode(String code);

    /**
     * 获取租户购买的对应应用
     * @Author：SYQ
     * @Date：2021/6/21 15:56
     */
    String getRelatedTask(AuthoredUser user,String customTenantId,String activityId);

    /**
     * 获取基础资料/报表 信息
     * @param user
     * @param plat
     * @return
     */
    List<BaseItemDto> getActivitiesByPattern(AuthoredUser user, Integer plat);

    /**
     * 根据code获取所有应用
     * @Author：SYQ
     * @Date：2021/7/12 10:07
     */
    List<Map> getAppInfos(String code);

    /**
     * 根据themMap中的taskCode查询appId
     * @Author：SYQ
     * @Date：2021/5/19 11:21
     */
    Map<String,String> getAppId(String taskId);

    /**
     * 调用km的接口获取基础资料，报表以及手动发起项目的的信息
     * 2:手动发起项目  3：基础资料 4：报表
     *
     * @param dto dto
     * @return 结果
     */
    List<SearchPojo> dealSearch(SearchDto dto);

    /**
     *
     * @param codeList  任务code  项目code  基础资料code  报表code  发起项目code
     * @param type  项目/发起项目 project    任务/基础资料/报表  task
     * @return
     */
    List<TmAppDTO> getAppInfoByCodeAndType(String type, List<String> codeList);

    Map<String,Object> getTaskCardOptimizeRules();

    Map getActivityDefinition(String tmActivityId);

    Map<String,List<String>> getActivityDefinitionList(List<String> list);

    Map<String,Map> getActivityDefinitionListByPageCode(String tmTaskId, List<String> list, String pageCode);

    List<Map<String,Object>> getActivityDefinitionListTo(List<String> list);

    Boolean getOrderDisplay();

    Map<String,Object> postCardConfigByType(JSONObject jsonObject);

    Map<String, Object> getQueryCondition(String pageCode, String conditionType);



    WorkbenchSettingDTO getWorkbenchSetting(String pageCode, String configType);

    /**
     * 查询项目卡的自定义列
     * @param request
     * @return
     */
    List<TaskCardFieldVO> customColumn(ProjectCustomColumnRequest request);
}
