package com.digiwin.athena.atmc.http.restful.thememap.impl;

import cn.hutool.json.JSONUtil;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.HttpUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.http.constant.GlobalConstant;
import com.digiwin.athena.atmc.http.constant.KgApiConstant;
import com.digiwin.athena.atmc.http.constant.ManualTaskConstant;
import com.digiwin.athena.atmc.http.domain.ProjectCustomColumnRequest;
import com.digiwin.athena.atmc.http.domain.TaskCardFieldRequest;
import com.digiwin.athena.atmc.http.domain.TaskCardFieldVO;
import com.digiwin.athena.atmc.http.domain.search.BaseItemDto;
import com.digiwin.athena.atmc.http.domain.search.SearchDto;
import com.digiwin.athena.atmc.http.domain.search.SearchPojo;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.thememap.ThemeMapService;
import com.digiwin.athena.atmc.http.restful.thememap.model.BusinessKeyDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmActivitiesResponseDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmActivityResponseDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmAppDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmAppExpireChangeComponentDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmApplicationDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmAssignConfigDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmDataState;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmReportDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmSolvePlanActivityDataDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmTaskDefineResponseDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.WorkbenchSettingDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.*;
import com.digiwin.athena.atmc.http.util.AtmcStrUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

import java.text.MessageFormat;
import java.util.*;

@Service
@Slf4j
public class ThemeMapServiceImpl implements ThemeMapService {
    private static final int NOT_NEED_SEARCH = -999;
    private static final String APPLY_PROJECT_TYPE_STR = "2";
    private static final String APPLY_ENTRY_TYPE_STR = "3";
    private static final String APPLY_REPORT_TYPE_STR = "4";

    private static final String REPORT_PATTERN = "STATEMENT";
    public static final String BASE_DATA_PATTERN = "DATA_ENTRY";


    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    private MessageUtils messageUtils;

    /**
     * 获取指定任务的任务定义
     *
     * @param taskId
     * @return
     */
    public TmTaskDefineResponseDTO getTask(String taskId) {

        TmTaskDefineResponseDTO result = null;

        String uri = envProperties.getKnowledgeGraphUri() + KgApiConstant.TASK_DEFINITION_WITH_MULTI_LANGUAGE_TASK_ID;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String, String> param = new HashMap<>();
        param.put("taskId", taskId);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        ResponseEntity<BaseResultDTO<TmTaskDefineResponseDTO>> responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<TmTaskDefineResponseDTO>>() {
                    }, param);
        } catch (Exception e) {
            log.error("url: {}, error: ", uri, e);
            throw e;
        }
        result = Objects.requireNonNull(responseEntity.getBody()).getResponseWithException("");

        if (result != null) {
            if (result.getMerge() == null) {
                //merge如果为null，则默认为true
                result.setMerge(true);
            }
            if (result.getAssignAble() == null) {
                //assignAble如果为Null，则默认为true
                result.setAssignAble(true);
            }
            if (Objects.equals(result.getAssignAble(), Boolean.TRUE) && result.getAssignConfig() == null) {
                TmAssignConfigDTO assignConfig = TmAssignConfigDTO.builder()
                        .assignAble(result.getAssignAble())
                        .assignTo(result.getAssignTo())
                        .build();
                result.setAssignConfig(assignConfig);
            }
        }
        return result;

    }

    /**
     * 获取指定任务的活动定义
     *
     * @param taskId
     * @return
     */
    public TmActivitiesResponseDTO getActivities(String taskId, String compositionId) {
        String uri = envProperties.getKnowledgeGraphUri() + KgApiConstant.TASK_ACTIVITIES_WITH_MULTI_LANGUAGE_TASK_ID_COMPOSITION_ID;
        if (StringUtils.isEmpty(compositionId)) {
            uri = envProperties.getKnowledgeGraphUri() + KgApiConstant.TASK_ACTIVITIES_WITH_MULTI_LANGUAGE_TASK_ID;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String, String> param = new HashMap<>();
        param.put("taskId", taskId);
        param.put("compositionId", compositionId);
        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        ResponseEntity<BaseResultDTO<TmActivitiesResponseDTO>> responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<TmActivitiesResponseDTO>>() {
                    },
                    param);

            return Objects.requireNonNull(responseEntity.getBody()).getResponseWithException("");
        }catch (Exception e) {
            log.error("url: {}, error: ", uri, e);
            throw e;
        }
    }

    public TmActivityResponseDTO getActivityAction(String tmTaskId, String tmActivityId, String pageCode) {

        TmActivityResponseDTO result = null;

        String uri = envProperties.getKnowledgeGraphUri() + KgApiConstant.TASK_ACTIVITY_DEFINITION_TASK_ID_ACTIVITY_ID_PAGE_CODE;
        if(ManualTaskConstant.VIRTUAL_PROJECT.equals(tmTaskId)){
            uri = envProperties.getKnowledgeGraphUri() + KgApiConstant.TASK_ACTIVITY_DEFINITION_ACTIVITY_ID_PAGE_CODE;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String, String> param = new HashMap<>();
        param.put("taskId", tmTaskId);
        param.put("activityId", tmActivityId);
        param.put("pageCode", pageCode);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        try {
            ResponseEntity<Object> respEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<Object>() {
                    }, param);
            BaseResultDTO<TmActivityResponseDTO> resultDTO = HttpUtils.descResponseRtnBody(uri, null, respEntity, new TypeReference<TmActivityResponseDTO>() {
            });
            if (resultDTO == null) {
                throw ErrorCodeEnum.KM_RTN_ERROR.getBusinessExceptionWithArgs(tmActivityId);
            }
            // 应用过期
            result = resultDTO.getResponse();
        } catch (Exception e) {
            log.error("url: {}, error: ", uri, e);
            throw e;
        }
        if (result != null) {
            //xuxx 2022-11-01 调整xxx-card中增加DataStates，将原有card中的内容全部移动到DataStates中，如果同时存在，以DataStates里的为主
            if(result.getPages() != null && CollectionUtils.isNotEmpty(result.getPages().getDataStates()) && result.getPages().getDataStates().size()>0 ){
                TmDataState dataState = result.getPages().getDataStates().get(0);
                result.getPages().setCardCache(dataState.getCardCache());
            }
            //需要兼容以前的，暂时不能删除
            if (result.getPages() != null && result.getPages().getCardCache() == null) {
                //未设置是否缓存，默认缓存
                result.getPages().setCardCache(true);
            }

            if (result.getAssignAble() == null) {
                //assignAble如果为Null，则默认为true
                result.setAssignAble(true);
            }
            if (Objects.equals(result.getAssignAble(), Boolean.TRUE) && result.getAssignConfig() == null) {
                TmAssignConfigDTO assignConfig = TmAssignConfigDTO.builder()
                        .assignAble(result.getAssignAble())
                        .assignTo(result.getAssignTo())
                        .build();
                result.setAssignConfig(assignConfig);
            }
        } else {
            throw ErrorCodeEnum.KM_RTN_NULL.getBusinessExceptionWithArgs(tmActivityId);
        }
        return result;

    }


    public Map getActivityAction2(String tmTaskId, String tmActivityId, String pageCode) {

        Map result = null;

        String uri = envProperties.getKnowledgeGraphUri() + KgApiConstant.TASK_ACTIVITY_DEFINITION_TASK_ID_ACTIVITY_ID_PAGE_CODE;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String, String> param = new HashMap<>();
        param.put("taskId", tmTaskId);
        param.put("activityId", tmActivityId);
        param.put("pageCode", pageCode);

        try{
            HttpEntity<?> httpEntity = new HttpEntity<>(headers);
            ResponseEntity<BaseResultDTO<Map>> responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<Map>>() {
            }, param);
            result = responseEntity.getBody().getResponseWithException("");
            return result;
        } catch (Exception e) {
            log.error("url: {}, error: ", uri, e);
            throw e;
        }
    }


    public Map executeFormula(String formulaId) {
        Map result = null;

        String uri = envProperties.getKnowledgeGraphUri() + KgApiConstant.TENANT_SETTINGS_FORMULA;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        Map<String, String> param = new HashMap<>();
        param.put("formulaId", formulaId);
        try {
            HttpEntity<?> httpEntity = new HttpEntity<>(headers);
            ResponseEntity<BaseResultDTO<Map>> responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,  new ParameterizedTypeReference<BaseResultDTO<Map>>(){
            }, param);
            result = responseEntity.getBody().getResponseWithException("");
            return result;
        }catch (Exception e) {
            log.error("url: {}, error: ", uri, e);
            throw e;
        }
    }

    public TmSolvePlanActivityDataDTO getSolvePlanActivities(String dataName, String planId) {
        String uri = envProperties.getKnowledgeGraphUri() + KgApiConstant.ACTIVITY_QUERY_COMPOSITION_BY_SOLVE_PLAN;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String, String> param = new HashMap<>();
        param.put("dataName", dataName);
        param.put("planId", planId);

        try {
            HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
            ResponseEntity<BaseResultDTO<TmSolvePlanActivityDataDTO>> responseEntity = restTemplate.exchange(uri, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<TmSolvePlanActivityDataDTO>>() {
                    }, new HashMap<>());
            return Objects.requireNonNull(responseEntity.getBody()).getResponseWithException("");
        }catch (Exception e) {
            log.error("url: {}, error: ", uri, e);
            throw e;
        }
    }

    private Map getResponse(Map responseMap) {
        if (responseMap != null && responseMap.containsKey("response") && responseMap.get("response") instanceof Map) {
            return (Map) responseMap.get("response");
        }

        return null;
    }

    private void addLang(HttpHeaders headers) {
        headers.add("locale", LocaleContextHolder.getLocale().toString());
    }

    /**
     * 根据项目/任务code 获取挂载的报表概要信息列表
     *
     * @param bizCode
     * @param type
     * @return
     */
    @Override
    public List<TmReportDTO> getReportSummaryList(String bizCode, Integer type, String userId) {

        String url = UriComponentsBuilder.fromHttpUrl(envProperties.getKnowledgeGraphUri() + KgApiConstant.TASK_REPORTS_BY_BIZ_CODE_NTYPE)
                .queryParam("bizCode", bizCode)
                .queryParam("type", type)
                .queryParam("userId", userId)
                .build()
                .toUriString();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", getToken());
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
        try {
            ResponseEntity<BaseResultDTO<List<TmReportDTO>>> responseEntity = restTemplate.exchange(url, HttpMethod.GET, requestEntity,
                    new ParameterizedTypeReference<BaseResultDTO<List<TmReportDTO>>>() {
                    });
            return responseEntity.getBody().getResponseWithException("[ThemeMapServiceImpl.getReportSummaryList] get report summary list failed");
        } catch (Exception e) {
            log.error("url: {}, error: ", url, e);
            throw e;
        }
    }

    /**
     * 获取报表附属的任务或者项目作业列表
     *
     * @param reportCode 报表tmActivityId
     * @param type       1：项目，2：任务
     * @return
     */
    @Override
    public List<TmReportDTO> getReportRelativeActivities(String reportCode, Integer type) {
        String url = UriComponentsBuilder.fromHttpUrl(envProperties.getKnowledgeGraphUri() + KgApiConstant.TASK_BIZS_BY_REPORT_CODE_NTYPE)
                .queryParam("reportCode", reportCode)
                .queryParam("type", type)
                .build()
                .toUriString();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", getToken());
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
        try{
            ResponseEntity<BaseResultDTO<List<TmReportDTO>>> responseEntity = restTemplate.exchange(url, HttpMethod.GET, requestEntity,
                    new ParameterizedTypeReference<BaseResultDTO<List<TmReportDTO>>>() {
                    });
            return responseEntity.getBody().getResponseWithException("");
        } catch (Exception e) {
            log.error("url: {}, error: ", url, e);
            throw e;
        }
    }

    /**
     * 根据项目/任务code、报表code获取报表详情信息
     *
     * @param bizCode
     * @param type
     * @param reportCode
     * @return
     */
    @Override
    public TmReportDTO getReportDetail(String bizCode, Integer type, String reportCode) {
        String url = UriComponentsBuilder.fromHttpUrl(envProperties.getKnowledgeGraphUri() + KgApiConstant.TASK_REPORT_BY_BIZ_CODE_NTYPE_NREPORT_CODE)
                .queryParam("bizCode", bizCode)
                .queryParam("type", type)
                .queryParam("reportCode", reportCode)
                .build()
                .toUriString();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", getToken());
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
        try{
            ResponseEntity<BaseResultDTO<TmReportDTO>> responseEntity = restTemplate.exchange(url, HttpMethod.GET, requestEntity
                    , new ParameterizedTypeReference<BaseResultDTO<TmReportDTO>>() {
                    });
            return responseEntity.getBody().getResponseWithException("");
        } catch (Exception e) {
            log.error("url: {}, error: ", url, e);
            throw e;
        }
    }

    private String getToken() {
        // 优先使用代理token
        if (null != AppAuthContextHolder.getContext().getProxyAuthoredUser()) {
            return AppAuthContextHolder.getContext().getProxyAuthoredUser().getToken();
        } else {
            return AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        }
    }

    /**
     * 任务引擎-查询themeMap项目所属的应用列表
     *
     * @param tmProjectId themeMap项目编号
     * @return
     */
    @Deprecated
    public List<TmAppDTO> getAppsByProjectIdForTaskEngine(String tmProjectId) {
        String uri = envProperties.getDataMapUri() + KgApiConstant.RESTFUL_STANDARD_DATAMAP_APP_PROJECT_APPS;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String, String> param = new HashMap<>();
        param.put("code", tmProjectId);

        List<TmAppDTO> result = null;

        try{
            HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
            ResponseEntity<BaseResultDTO<List<TmAppDTO>>> responseEntity = restTemplate.exchange(uri, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<List<TmAppDTO>>>() {
                    }, new HashMap<>());
            result = responseEntity.getBody().getResponseWithException("");
            return result;
        } catch (Exception e) {
            log.error("url: {}, error: ", uri, e);
            throw e;
        }
    }

    /**
     * 流程引擎-查询themeMap项目所属的应用列表
     *
     * @param tmProjectId themeMap项目编号
     * @return
     */
    public List<TmAppDTO> getAppsByProjectIdForFlowEngine(String tmProjectId) {
        String uri = envProperties.getKnowledgeGraphUri() + KgApiConstant.RESTFUL_SERVICE_KNOWLEDGEGRAPH_APP_APP_CODE_BY_TASK_CODE;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String, String> param = new HashMap<>();
        param.put("code", tmProjectId);

        List<TmAppDTO> result = null;
        try {
            HttpEntity<?> httpEntity = new HttpEntity<>(headers);
            ResponseEntity<BaseResultDTO<List<TmAppDTO>>> responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<List<TmAppDTO>>>() {
                    }, param);

            result = responseEntity.getBody().getResponseWithException("");
            return result;
        } catch (Exception e) {
            log.error("url: {}, error: ", uri, e);
            throw e;
        }
    }

    /**
     * 获取任务的关联任务code
     *
     * @param tmTaskId
     * @param tmActivityId
     * @param pageCode
     * @return
     */
    public String getActivityTargetCode(String tmTaskId, String tmActivityId, String pageCode) {

        TmActivityResponseDTO result = new TmActivityResponseDTO();

        String uri = envProperties.getKnowledgeGraphUri() + KgApiConstant.TASK_ACTIVITY_START_TARGET_CODE_TASK_ID_ACTIVITY_ID_PAGE_CODE;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String, String> param = new HashMap<>();
        param.put("taskId", tmTaskId);
        param.put("activityId", tmActivityId);
        param.put("pageCode", pageCode);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        ResponseEntity<BaseResultDTO<TmActivityResponseDTO>> responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<TmActivityResponseDTO>>() {
                    }, param);
            result = responseEntity.getBody().getResponseWithException("");
        } catch (Exception e) {
            log.error("url: {}, error: ", uri, e);
            throw e;
        }
        if (result != null) {
            //未设置是否缓存，默认缓存
            return result.getTargetApproveActivity();
        }
        return null;

    }

    /**
     * 根据emailCode和语言别，获取邮件模板ID
     * majianfu 迭代22/需求ID：1854 2021-11-29
     *
     * @param emailCode
     * @param locale
     * @return 请求成功，则返回邮件模板ID（可能为null）；请求失败，则抛出599 BusinessException
     */
    @Override
    public Map getEmailEventIdByLocale(String emailCode, String locale) {
        String url = UriComponentsBuilder.fromHttpUrl(envProperties.getKnowledgeGraphUri() + KgApiConstant.VIEW_EMAIL)
                .queryParam("emailCode", emailCode)
                .queryParam("locale", locale)
                .build().toUriString();

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        try {
            ResponseEntity<BaseResultDTO<Map>> respEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<Map>>() {
            });
            return respEntity.getBody().getResponseWithException(messageUtils.getMessage("exception.KG.email.mould.error"));
        } catch (Exception e) {
            log.error("url: {}, error: ", url, e);
            throw e;
        }
    }

    /**
     * 获取项目/任务的业务主键
     *
     * @Author：SYQ
     * @Date：2021/12/7 13:52
     */
    @Override
    public BusinessKeyDTO getTaskActivityBK(String objectType, String objectValue) {
        BusinessKeyDTO result = null;
        //请求地址
        String url = envProperties.getKnowledgeGraphUri() + KgApiConstant.VIEW_BK;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //入参
        Map<String, String> paramMap = new HashMap<>();
        paramMap.put("objectType", objectType);
        paramMap.put("objectValue", objectValue);
        HttpEntity<?> httpEntity = new HttpEntity<>(paramMap, headers);
        //请求接口
        try {
            ResponseEntity<BaseResultDTO<BusinessKeyDTO>> responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<BusinessKeyDTO>>() {
                    });
            result = responseEntity.getBody().getResponseWithException("");
        } catch (Exception e) {
            log.error("url: {}, error: ", url, e);
            throw e;
        }
        return result;
    }

    @Override
    public JSONArray getTmTaskAndActivityBk(String objectType, String objectValue, AuthoredUser user) {
        JSONArray result = null;
        String url = "";
        try {
            //请求地址
            url = envProperties.getKnowledgeGraphUri() + KgApiConstant.VIEW_BK;
            //头部
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            log.info("current user: "+user);
            if (null == user) {
                headers.set("token", getToken());
                log.info(" context token: " + getToken());
            } else {
                headers.set("token", user.getToken());
            }
            //入参
            Map<String, String> paramDetailMap = new HashMap<>();
            paramDetailMap.put("objectType", objectType);
            paramDetailMap.put("objectValue", objectValue);
            Map<String, Map<String, String>> paramMap = new HashMap<>();
            paramMap.put("request", paramDetailMap);
            HttpEntity<?> httpEntity = new HttpEntity<>(paramMap, headers);
            //请求接口
            ResponseEntity<BaseResultDTO> responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, BaseResultDTO.class);
            Object response = responseEntity.getBody().getResponseWithException("");
            if (response != null) {
                // 解决net.sf.json 将null解析成"null"的问题
                JSONObject jsonObject = JsonUtils.jsonToObject(JsonUtils.objectToString(response), JSONObject.class);
                if (jsonObject.containsKey("bkInfo")) {
                    result = jsonObject.getJSONArray("bkInfo");
                }
            }
        } catch (Exception e) {
            log.error("url: {}, error: ", url, e);
            throw e;
        }
        return result;
    }

    /**
     * 根据 应用code 获取其包含的项目code列表
     *
     * @param appCode
     * @return
     */
    public List<String> getTaskCodeListByAppCode(String appCode) {
        String uri = envProperties.getKnowledgeGraphUri() + KgApiConstant.RESTFUL_SERVICE_KNOWLEDGEGRAPH_APP_TASK_CODE_APP_CODE;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String, String> param = new HashMap<>();
        param.put("appCode", appCode);

        List<String> result = null;

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        try{
            ResponseEntity<BaseResultDTO<List<String>>> responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<List<String>>>() {
                    }, param);
            result = responseEntity.getBody().getResponseWithException("");
        } catch (Exception e) {
            log.error("url: {}, error: ", uri, e);
            throw e;
        }
        return result;
    }

    /**
     * 批量获取项目的转派定义
     *
     * @param taskCodes 项目code列表
     * @return
     */
    public List<TmTaskDefineResponseDTO> getBatchTaskAssigns(List<String> taskCodes) {
        List<TmTaskDefineResponseDTO> result = null;

        //请求地址
        String url = envProperties.getKnowledgeGraphUri() + KgApiConstant.BATCH_TASK_BASIC;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //入参
        Map<String, Object> rootPara = new HashMap<>();
        Map<String, Object> qPara = new HashMap<>();
        qPara.put("codes", taskCodes);
        rootPara.put("q", qPara);
        HttpEntity<?> httpEntity = new HttpEntity<>(rootPara, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<TmTaskDefineResponseDTO>>> responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<TmTaskDefineResponseDTO>>>() {
            }, rootPara);
            result = responseEntity.getBody().getResponseWithException("");
        } catch (Exception e) {
            log.error("url: {}, error: ", url, e);
            throw e;
        }
        if (CollectionUtils.isNotEmpty(result)) {
            result.forEach(x -> {
                if (x.getAssignAble() == null) {
                    x.setAssignAble(true);
                }

                if (Objects.equals(x.getAssignAble(), Boolean.TRUE) && x.getAssignConfig() == null) {
                    TmAssignConfigDTO assignConfig = TmAssignConfigDTO.builder()
                            .assignAble(x.getAssignAble())
                            .assignTo(x.getAssignTo())
                            .build();
                    x.setAssignConfig(assignConfig);
                }
            });
        }
        return result;
    }

    /**
     * 批量获取任务的转派定义
     *
     * @param activities map结构 {"taskCode":"task_RE_Preparation","activityCode":"purchaseApproval"}
     * @return
     */
    public List<TmActivityResponseDTO> getBatchActivityAssigns(List<Map> activities) {
        List<TmActivityResponseDTO> result = null;

        //请求地址
        String url = envProperties.getKnowledgeGraphUri() + KgApiConstant.BATCH_ACTIVITY_BASIC;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //入参
        Map<String, Object> rootPara = new HashMap<>();
        Map<String, Object> qPara = new HashMap<>();
        qPara.put("taskAndActivities", activities);
        rootPara.put("q", qPara);
        HttpEntity<?> httpEntity = new HttpEntity<>(rootPara, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<TmActivityResponseDTO>>> responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<TmActivityResponseDTO>>>() {
            }, rootPara);
            result = responseEntity.getBody().getResponseWithException("");
        } catch (Exception e) {
            log.error("url: {}, error: ", url, e);
            throw e;
        }
        if (CollectionUtils.isNotEmpty(result)) {
            result.forEach(x -> {
                if (x.getAssignAble() == null) {
                    x.setAssignAble(true);
                }

                if (Objects.equals(x.getAssignAble(), Boolean.TRUE) && x.getAssignConfig() == null) {
                    TmAssignConfigDTO assignConfig = TmAssignConfigDTO.builder()
                            .assignAble(x.getAssignAble())
                            .assignTo(x.getAssignTo())
                            .build();
                    x.setAssignConfig(assignConfig);
                }
            });
        }
        return result;
    }

    /**
     * 获取报表resId
     *
     * @param token
     * @param params
     * @return
     */
    @Override
    public Map<String, String> getReportResId(String token, Map params) {
        String url = envProperties.getKnowledgeGraphUri() + KgApiConstant.STATEMENT_RES_ID;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("locale", LocaleContextHolder.getLocale().toString());
        headers.set("token", token);

        Map<String, Object> reqBody = new HashMap<>();
        reqBody.put("queryObject", params);
        HttpEntity<?> httpEntity = new HttpEntity<>(reqBody, headers);
        try {
            ResponseEntity<BaseResultDTO<Map<String, String>>> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<Map<String, String>>>() {
            });
            return respEntity.getBody().getResponseWithException("");
        }  catch (Exception e) {
            log.error("url: {}, error: ", url, e);
            throw e;
        }
    }

    /**
     * 获取作业inputData数据定义
     *
     * @param token
     * @param tmActivityId
     * @return
     */
    @Override
    public Map getActivityInputDataDefine(String token, String tmActivityId) {

        String url = envProperties.getKnowledgeGraphUri() + AtmcStrUtil.format(KgApiConstant.ACTIVITY_INPUT_DATA_ACTIVITY_ID,tmActivityId);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("locale", LocaleContextHolder.getLocale().toString());
        headers.set("token", token);

        HttpEntity<?> httpEntity = new HttpEntity<>(null, headers);
        try {
            ResponseEntity<BaseResultDTO<Map>> respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<Map>>() {
            });
            return respEntity.getBody().getResponseWithException("");
        } catch (Exception e) {
            log.error("url: {}, error: ", url, e);
            throw e;
        }
    }

    /**
     * 获取过期应用的组件列表（项目、任务、基础资料录入、报表等）
     *
     * @param appExpireChangeComponent
     * @return
     */
    @Override
    public TmAppExpireChangeComponentDTO getAppExpireChangeComponent(TmAppExpireChangeComponentDTO appExpireChangeComponent) {
        String url = envProperties.getKnowledgeGraphUri() + KgApiConstant.COMPONENT_QUERY_COMPONENT;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        HttpEntity<TmAppExpireChangeComponentDTO> httpEntity = new HttpEntity<>(appExpireChangeComponent, headers);
        try {
            ResponseEntity<BaseResultDTO<TmAppExpireChangeComponentDTO>> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<TmAppExpireChangeComponentDTO>>() {
                    });
            if (null != respEntity.getBody() && respEntity.getBody().isOK()) {
                return respEntity.getBody().getResponse();
            } else {
                log.error(messageUtils.getMessage("exception.KG.overdue.component1"), appExpireChangeComponent, JsonUtils.objectToString(respEntity.getBody()));
                String errMsg = MessageFormat.format(messageUtils.getMessage("exception.KG.overdue.component2"),
                        JsonUtils.objectToString(appExpireChangeComponent), JsonUtils.objectToString(respEntity.getBody()));
                throw BusinessException.create(errMsg);
            }
        } catch (Exception e) {
            log.error("url: {}, error: ", url, e);
            throw e;
        }
    }

    /**
     * 用appCode获取应用信息
     *
     * @param
     * @return
     */
    @Override
    public TmApplicationDTO getApplicationByCode(String code) {

        TmApplicationDTO result = null;

        String uri = envProperties.getKnowledgeGraphUri() + KgApiConstant.APP_APPLICATION_BY_CODE;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String, String> param = new HashMap<>();
        param.put("code", code);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        ResponseEntity<BaseResultDTO<TmApplicationDTO>> responseEntity = null;
        try{
            responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<TmApplicationDTO>>() {
                    }, param);
            result = responseEntity.getBody().getResponseWithException("");
            return result;
        } catch (Exception e) {
            log.error("url: {}, error: ", uri, e);
            throw e;
        }
    }

    /**
     * 根据themMap中的taskCode查询appId
     * @Author：SYQ
     * @Date：2021/5/19 11:21
     */
    public Map<String,String> getAppId(String taskId){
        Map<String,String> resultMap = new HashMap<>();
        //查询参数
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("taskId",taskId);
        //头部信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //获取appId接口地址
        String getAppIdUrl = envProperties.getKnowledgeGraphUri() + KgApiConstant.TASK_APP_SUBSCRIPTION_TASK_ID;
        //查询数据
        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        try {
            ResponseEntity<BaseResultDTO<Map>> appIdResponse = restTemplate.exchange(getAppIdUrl, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<Map>>() {
            }, paramMap);
            Map response = appIdResponse.getBody().getResponseWithException("");
            //获取appId
            if(MapUtils.isNotEmpty(response)){
                resultMap = JsonUtils.jsonToObject(JsonUtils.objectToString(response),Map.class);
            }
            return resultMap;
        } catch (Exception e) {
            log.error("url: {}, error: ", getAppIdUrl, e);
            throw e;
        }

    }

    /**
     * 根据code获取所有应用
     * @Author：SYQ
     * @Date：2021/7/12 10:07
     */
    public List<Map> getAppInfos(String code){
        List<Map> resultList = new ArrayList<>();
        if(org.apache.commons.lang.StringUtils.isEmpty(code)){
            return resultList;
        }
        //查询参数
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("code",code);
        //头部信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        //设置语言别，获取对应的语言别信息
        headers.add("locale",LocaleContextHolder.getLocale().toString());

        //获取appId接口地址
        String getAppIdUrl = envProperties.getKnowledgeGraphUri() + KgApiConstant.APP_APP_CODE_BY_TASK_CODE;
        //查询数据
        try{
            HttpEntity<?> httpEntity = new HttpEntity<>(headers);
            ResponseEntity<BaseResultDTO<List<Map>>> appIdResponse = restTemplate.exchange(getAppIdUrl, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<Map>>>() {
            }, paramMap);
            List<Map> response = appIdResponse.getBody().getResponseWithException("");
            //获取appId
            if(CollectionUtils.isNotEmpty(response)){
                resultList = JsonUtils.jsonToObject(JsonUtils.objectToString(response),List.class);
            }
            return resultList;
        } catch (Exception e) {
            log.error("url: {}, error: ", getAppIdUrl, e);
            throw e;
        }
    }

    /**
     * 获取租户购买的对应应用
     * @Author：SYQ
     * @Date：2021/6/21 15:56
     */
    public String getRelatedTask(AuthoredUser user,String customTenantId,String activityId){
        String taskId = "";
        //获取用户信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());
        //接口地址
        String url = envProperties.getKnowledgeGraphUri() + KgApiConstant.TASK_QUERY_RELATED_TASK;
        //请求参数
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("tenantId",customTenantId);
        paramMap.put("activityId",activityId);
        HttpEntity<?> httpEntity = new HttpEntity<>(paramMap,headers);
        //调用接口
        try {
            ResponseEntity<Map> responseEntity = restTemplate.postForEntity(url,httpEntity, Map.class);
            if (responseEntity.getStatusCode() == HttpStatus.OK) {
                Object taskIdObj = responseEntity.getBody().get("response");
                if(taskIdObj != null){
                    taskId = taskIdObj.toString();
                }
            }
            return taskId;
        } catch (Exception e) {
            log.error("url: {}, error: ", url, e);
            throw e;
        }

    }

    /**
     * 根据用户信息，从km查询对应的基础资料信息
     *
     * @param user 用户信息
     * @param plat 所属模块 0：基础资料 1：报表
     * @return list
     */
    public List<BaseItemDto> getActivitiesByPattern(AuthoredUser user, Integer plat) {
        String uri = envProperties.getKnowledgeGraphUri() + "knowledgegraph/task/activitiesAndSortByPattern?pattern=";
        String pattern = "";
        //基础资料pattern
        if (Objects.equals(plat, 0)) {
            pattern = BASE_DATA_PATTERN;
        }
        //报表pattern
        else if (Objects.equals(plat, 1)) {
            pattern = REPORT_PATTERN;
        }
        uri = uri + pattern;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("locale", LocaleContextHolder.getLocale().toString());
        headers.set("token", user.getToken());
        Map<String, String> param = new HashMap<>();
        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        ResponseEntity<BaseResultDTO<List<BaseItemDto>>> respMap;
        try {
            respMap = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<List<BaseItemDto>>>() {
                    },
                    param);
            return respMap.getBody().getResponseWithException("");
        } catch (Exception e) {
            log.error("url: {}, error: ", uri, e);
            throw e;
        }
    }

    /**
     * 调用km的接口获取基础资料，报表以及手动发起项目的的信息
     * 2:手动发起项目  3：基础资料 4：报表
     *
     * @param dto dto
     * @return 结果
     */
    @Override
    public List<SearchPojo> dealSearch(SearchDto dto) {
        List<SearchPojo> retList = new ArrayList<>();
        //如果是不支持的type类型，则直接返回空数据
        if (null != dto.getType() && dto.getType().equals(NOT_NEED_SEARCH)) {
            return new ArrayList<>();
        }

        //获取返回的信息
        String getAppIdUrl = envProperties.getKnowledgeGraphUri() + KgApiConstant.TASK_QUERY_ITEM_CONDITION_ITEM_NAME;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        Map<String, String> param = new HashMap<>();
        param.put("itemName", dto.getName());
        //查询数据
        JSONArray resultArr = new JSONArray();
        try {
            HttpEntity<?> httpEntity = new HttpEntity<>(headers);
            ResponseEntity<Map> entryResp = restTemplate.exchange(getAppIdUrl, HttpMethod.GET, httpEntity, Map.class, param);

            //获取查询结果
            if (entryResp.getStatusCode() == HttpStatus.OK && (null != entryResp.getBody())) {
                Object response = entryResp.getBody().get("response");
                if (response != null && response != "") {
                    resultArr = JsonUtils.jsonToObject(JsonUtils.objectToString(response), JSONArray.class);
                }
            }

        }  catch (Exception e) {
            log.error("url: {}, error: ", getAppIdUrl, e);
            throw e;
        }
        if (resultArr == null || resultArr.isEmpty()) {
            //异常日志记录
            log.error("query search data with none from km.");
            return retList;
        }
        for (int i = 0; i < resultArr.size(); i++) {
            SearchPojo pojo = JsonUtils.jsonToObject(JsonUtils.objectToString(resultArr.getJSONObject(i)),SearchPojo.class);
            //手动发起项目处理
            if ("Task".equals(pojo.getType())) {
                pojo.setType(APPLY_PROJECT_TYPE_STR);
            }
            //报表处理
            else if ("Activity".equals(pojo.getType()) && "STATEMENT".equals(pojo.getPattern())) {
                pojo.setType(APPLY_REPORT_TYPE_STR);
            }
            //基础资料处理
            else if ("Activity".equals(pojo.getType()) && "DATA_ENTRY".equals(pojo.getPattern())) {
                pojo.setType(APPLY_ENTRY_TYPE_STR);
            }
            if(dto.getType() != null && !Objects.equals(dto.getType(),Integer.valueOf(pojo.getType()))){
                continue;
            }
            retList.add(pojo);
        }
        return retList;
    }

    @Override
    public List<TmAppDTO> getAppInfoByCodeAndType(String type, List<String> codeList) {

        String url = envProperties.getKnowledgeGraphUri() + KgApiConstant.TASK_APPLICATION_RELATION;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);

        Map<String, Object> params = new HashMap<>();
        params.put("type", type);
        params.put("codes", codeList);
        HttpEntity<?> httpEntity = new HttpEntity<>(params,headers);
        ResponseEntity<BaseResultDTO<List<TmAppDTO>>> respEntity = null;
        try {
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<TmAppDTO>>>() {
            });
            log.info("[getAppInfoByCodeAndType]  type = {}, codes = {}, result = {}", type, JsonUtils.objectToString(codeList), JsonUtils.objectToString(respEntity));
        }
        catch (Exception e){
            log.error("[getAppInfoByCodeAndType] execute km [knowledgegraph/task/applicationRelation] fail, error = {}", e.getMessage());
        }

        if (null != respEntity && null != respEntity.getBody()){
            return  respEntity.getBody().getResponseWithException("");
        }
        return null;
    }


    @Override
    public Map<String, Object> getTaskCardOptimizeRules() {
        //获取返回的信息
        String getAppIdUrl = envProperties.getKnowledgeGraphUri() + KgApiConstant.TASK_CARD_OPTIMIZE_RULES;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        Map<String, Object> result = new HashMap<>();
        Map<String, String> param = new HashMap<>();
        //查询数据
        try {
            HttpEntity<?> httpEntity = new HttpEntity<>(headers);
            ResponseEntity<Map> entryResp = restTemplate.exchange(getAppIdUrl, HttpMethod.GET, httpEntity, Map.class, param);

            //获取查询结果
            if (entryResp.getStatusCode() == HttpStatus.OK && (null != entryResp.getBody())) {
                Object response = entryResp.getBody().get("response");
                if (response != null && response != "") {
                    result =  (Map<String, Object>) response;
                }
            }

        }  catch (Exception e) {
            log.error("url: {}, error: ", getAppIdUrl, e);
            throw e;
        }
        return result;
    }

    @Override
    public Boolean getOrderDisplay() {
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/task/taskOrderStatus";
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", getToken());
        Map<String, Object> result = new HashMap<>();
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
        Boolean status = false;
        try {
            ResponseEntity<Object> respEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity,
                    new ParameterizedTypeReference<Object>() {
                    });
            status = HttpUtils.descResponseBody(url, null, respEntity, new TypeReference<Boolean>() {
            });
        } catch (Exception e) {
            log.error("【km server error】:{}",e.getMessage());
        }
        return status;
    }

    @Override
    public WorkbenchSettingDTO getWorkbenchSetting(String pageCode, String configType) {
        String url = envProperties.getKnowledgeGraphUri() + KgApiConstant.WORKBENCH_SETTING;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        addLang(headers);
        Map<String, Object> param = new HashMap<>();
        param.put("pageCode", pageCode);
        param.put("configType", configType);
        param.put("appCondition", false);
        try {
            HttpEntity<?> httpEntity = new HttpEntity<>(headers);
            ResponseEntity<Object> responseEntity = restTemplate.exchange(url,
                    HttpMethod.GET,
                    httpEntity,
                    new ParameterizedTypeReference<Object>(){},
                    param);
            return HttpUtils.descResponseBody(url, null, responseEntity, new TypeReference<WorkbenchSettingDTO>(){});
        }catch (Exception e) {
            throw e;
        }
    }

    @Override
    public List<TaskCardFieldVO> customColumn(ProjectCustomColumnRequest request) {
        String uri = envProperties.getKnowledgeGraphUri()+ KgApiConstant.view_taskCardField;
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", getToken());
        headers.setContentType(MediaType.APPLICATION_JSON);
        TaskCardFieldRequest taskCardFieldRequest = new TaskCardFieldRequest();
        taskCardFieldRequest.setPageCode("project-card");
        taskCardFieldRequest.setCode(request.getProjectCode());
        Map<String, Object> param = new HashMap<>();
        param.put("taskCardFieldRequest", taskCardFieldRequest);
        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
        ResponseEntity<BaseResultDTO<List<TaskCardFieldVO>>> responseEntity = restTemplate.exchange(uri, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<TaskCardFieldVO>>>() {
        });
        return responseEntity.getBody().getResponse();
    }

    @Override
    public Map<String,List<String>> getActivityDefinitionList(List<String> list) {
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/task/activityDefinitionList";
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", getToken());
        Map body = new HashMap();
        body.put("taskId", "");
        body.put("activityIds", list);
        body.put("pageCode", "task-card");
        Map<String, List<String>> result = new HashMap<>();
        HttpEntity<?> requestEntity = new HttpEntity<>(body, headers);
        try {
            ResponseEntity<Object> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity,
                    new ParameterizedTypeReference<Object>() {
                    });
            Map map = HttpUtils.descResponseBody(url, null, respEntity, new TypeReference<Map>() {
            });

            list.forEach(el -> {
                Object o = map.get(el);
                cn.hutool.json.JSONObject activityDefinition = JSONUtil.parseObj(o);
                cn.hutool.json.JSONObject jsonObject = JSONUtil.parseObj(activityDefinition.get("pages"));
                cn.hutool.json.JSONArray jsonArray = JSONUtil.parseArray(jsonObject.get("dataStates"));
                cn.hutool.json.JSONObject dataState = jsonArray.stream()
                        .map(e -> (cn.hutool.json.JSONObject) e)
                        .filter(e-> e.get("type")!=null)
                        .filter(e -> "all".equals(e.get("type").toString())).findFirst().get();
                cn.hutool.json.JSONObject taskCardFields = JSONUtil.parseObj(dataState.get("taskCardFields"));
                String dateSourceName ;
                if (taskCardFields.getStr("dateSourceName") == null) {
                    dateSourceName = taskCardFields.getStr("dataSourceName");
                } else {
                    dateSourceName = taskCardFields.getStr("dateSourceName");
                }
                cn.hutool.json.JSONObject dataSources = JSONUtil.parseObj(activityDefinition.get("dataSources"));
                Object dataSource = dataSources.get(dateSourceName);
                cn.hutool.json.JSONObject datasourceJson = JSONUtil.parseObj(dataSource);
                cn.hutool.json.JSONArray actionParams = JSONUtil.parseArray(datasourceJson.get("actionParams"));
                ArrayList<String> objects = new ArrayList<>();
                Optional<Object> optional = actionParams.stream()
                        .filter(e -> "PROCESS_VARIABLE".equals(((cn.hutool.json.JSONObject) e).get("type")))
                        .findFirst();
                if (optional.isPresent()) {
                    cn.hutool.json.JSONObject actionParam = JSONUtil.parseObj(optional.get());
                    String value = actionParam.getStr("value");
                    objects.add(value);
                    result.put(el, objects);
                }
            });
            return result;
        } catch (Exception e) {
            log.error("get activity error："+e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Map<String,Map> getActivityDefinitionListByPageCode(String tmTaskId,List<String> list,String pageCode) {
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/task/activityDefinitionList";
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", getToken());
        Map body = new HashMap();
        body.put("taskId", tmTaskId);
        body.put("activityIds", list);
        body.put("pageCode", pageCode);
        Map<String, Map> result = new HashMap<>();
        HttpEntity<?> requestEntity = new HttpEntity<>(body, headers);
        try {
            ResponseEntity<Object> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity,
                    new ParameterizedTypeReference<Object>() {
                    });
            return HttpUtils.descResponseBody(url, null, respEntity, new TypeReference<Map<String, Map>>() {});
        } catch (Exception e) {
            log.error("getActivityDefinitionListByPageCode error：{}",e);
        }
        return result;
    }

    @Override
    public List<Map<String,Object>> getActivityDefinitionListTo(List<String> list) {
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/task/activityDefinitionList";
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", getToken());
        Map body = new HashMap();
        body.put("taskId", "");
        body.put("activityIds", list);
        body.put("pageCode", "task-card");
        List<Map<String, Object>> result = new ArrayList<>();
        HttpEntity<?> requestEntity = new HttpEntity<>(body, headers);
        try {
            ResponseEntity<Object> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity,
                    new ParameterizedTypeReference<Object>() {
                    });
            Map map = HttpUtils.descResponseBody(url, null, respEntity, new TypeReference<Map>() {
            });
            list.forEach(el->{
                Object o = map.get(el);
                List arrayList = new ArrayList();
                try {
                    cn.hutool.json.JSONObject activityDefinition = JSONUtil.parseObj(o);
                    cn.hutool.json.JSONObject jsonObject = JSONUtil.parseObj(activityDefinition.get("pages"));
                    cn.hutool.json.JSONArray jsonArray = JSONUtil.parseArray(jsonObject.get("dataStates"));
                    cn.hutool.json.JSONObject dataState = jsonArray.stream()
                            .map(e -> (cn.hutool.json.JSONObject) e)
                            .filter(e -> e.get("type") != null)
                            .filter(e -> "all".equals(e.get("type").toString())).findFirst().get();
                    cn.hutool.json.JSONObject taskCardFields = JSONUtil.parseObj(dataState.get("taskCardFields"));
                    cn.hutool.json.JSONObject taskCardField = JSONUtil.parseObj(taskCardFields.get("taskCardField"));
                    cn.hutool.json.JSONArray columns = JSONUtil.parseArray(taskCardField.get("columns"));
                    for (Object column : columns) {
                        cn.hutool.json.JSONObject columnJson = JSONUtil.parseObj(column);
                        Map<String, String> element = new HashMap<>();
                        element.put("key", columnJson.get("code").toString());
                        element.put("name", columnJson.get("name").toString());
                        element.put("type", "businessKey");
                        arrayList.add(element);
                    }
                }
                catch (Exception e) {
                    log.error("get activity error："+e.getMessage());
                    e.printStackTrace();
                }
                Map<String, Object> onceMap = new HashMap<>();
                onceMap.put("columns", arrayList);
                onceMap.put("taskDefCode", el);
                result.add(onceMap);
            });
            return result;
        } catch (Exception e) {
            log.error("get activity error："+e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Map getActivityDefinition(String tmActivityId) {
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/task/activityDefinition?activityId=" + tmActivityId + "&pageCode=task-card";
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", getToken());
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
        Map<String, Object> result = new HashMap<>();
        try {
            ResponseEntity<Object> respEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity,
                    new ParameterizedTypeReference<Object>() {
                    });
            Map map = HttpUtils.descResponseBody(url, null, respEntity, new TypeReference<Map>() {
            });
            cn.hutool.json.JSONObject jsonObject = JSONUtil.parseObj(map.get("pages"));
            cn.hutool.json.JSONArray jsonArray = JSONUtil.parseArray(jsonObject.get("dataStates"));
            cn.hutool.json.JSONObject dataState = jsonArray.stream().map(e -> (cn.hutool.json.JSONObject) e).filter(e -> "all".equals(e.get("type").toString())).findFirst().get();
            cn.hutool.json.JSONObject taskCardFields = JSONUtil.parseObj(dataState.get("taskCardFields"));
            cn.hutool.json.JSONObject taskCardField = JSONUtil.parseObj(taskCardFields.get("taskCardField"));
            cn.hutool.json.JSONArray columns = JSONUtil.parseArray(taskCardField.get("columns"));
            List list = new ArrayList();
            for (Object column : columns) {
                cn.hutool.json.JSONObject columnJson = JSONUtil.parseObj(column);
                Map<String, String> element = new HashMap<>();
                element.put("key", columnJson.get("code").toString());
                element.put("name", columnJson.get("name").toString());
                element.put("type", "businessKey");
                list.add(element);
            }
            result.put("columns", list);
            result.put("taskDefCode", tmActivityId);
            return result;
        } catch (Exception e) {
            log.error("get activity error："+e.getMessage());
            e.printStackTrace();
        }
        return new HashMap();
    }

    @Override
    public Map<String, Object> postCardConfigByType(cn.hutool.json.JSONObject jsonObject) {
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/task/cardConfigByType";
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", getToken());
        Map<String, Object> result = new HashMap<>();
        Map<String, Object> body = new HashMap<>();
        body.put("cardConfigQuery",jsonObject);
        HttpEntity<?> requestEntity = new HttpEntity<>(body, headers);
        try {
            cn.hutool.json.JSONObject respJson= this.restTemplate.postForObject(url, requestEntity, cn.hutool.json.JSONObject.class);
            Map<String, Object> map = JsonUtils.jsonToObject(respJson.toJSONString(0), new TypeReference<Map<String, Object>>() {
            });
            result =  (Map<String, Object>) map.get("response");
            return result;
        } catch (Exception e) {
            log.error("【km server error】:{}", e);
        }
        return result;
    }


    @Override
    public Map<String, Object> getQueryCondition(String pageCode, String conditionType) {
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/task/queryCondition";
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", getToken());
        cn.hutool.json.JSONObject jsonObject = new cn.hutool.json.JSONObject();
        jsonObject.putIfAbsent("pageCode", pageCode);
        jsonObject.putIfAbsent("configType", conditionType);
        Map<String, Object> result = new HashMap<>();
        Map<String, Object> body = new HashMap<>();
        body.put("cardConditionQuery",jsonObject);
        HttpEntity<?> requestEntity = new HttpEntity<>(body, headers);
        ResponseEntity<Object> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity,
                new ParameterizedTypeReference<Object>() {
                });
        return HttpUtils.descResponseBody(url, null, respEntity, new TypeReference<Map<String, Object>>() {
        });

    }
}
