package com.digiwin.athena.atmc.http.restful.thememap.model;

import lombok.Data;

import java.util.List;

@Data
public class TmActivityPageDTO {

    private String title;
    private String subTitle;
    private String description;
    private String subDescription;

    private TmReasonDTO reason;

    private List<TmOperationDTO> operations;

    private String sourceType;

    private List<TmSummaryFieldDTO> summaryFields;

    /**
     * P4S1配置设计器结构page下面增加DataState
     * 数据状态列表，有几个状态，就显示几个页签
     */
    private List<TmDataState> dataStates;

    /**
     * 是否缓存summaryLayout，默认为true
     */
    private Boolean cardCache;

    /**
     * 是否可以转派，默认为false
     */
    private Boolean reassign = false;

    /**
     * 是否在标签也显示项目名称（taskName）
     */
    private Boolean showTaskNameInTab;

    /**
     * 项目卡通过API获取项目是否逾期时，API表示逾期的字段名
     */
    private String overduePropertyName;

    /**
     * 是否需要起定时任务刷新任务卡message
     */
    private Boolean scheduleRefreshCardMessage;

    /**
     * 刷新类型(默认 代表刷新所有) business(只刷新标签分组筛选排序)
     */
    private String scheduleRefreshCardType;

    /**
     * 在项目详情里增加配置subProjectQueryAction，可以配置api来获取关联的子项目的sourceid，然后平台根据sourceid获取到子项目列表。如果不配置，则默认根据当前项目id，关卡id去任务引擎查找从当前节点发起的子项目列表。
     */
    private SubProject subProject;

    @Data
    public static  class SubProject{
        /**
         * 查询逻辑
         */
        private TmActionDTO queryAction;
        /**
         * 指定查询结果中子项目字段
         */
        private String sourceIdField;
        /**
         * 子项目在tm的code
         */
        private String subProjectCode;
    }
}
