/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.bpm.impl;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.bpm.TaskEngineService;
import com.digiwin.athena.atmc.http.restful.bpm.model.BpmTaskApproveActivityDTO;
import com.digiwin.athena.atmc.http.restful.bpm.model.BpmTaskApprovePreviousActivityDTO;
import com.digiwin.athena.atmc.http.restful.bpm.model.BpmTaskApproveRequestDTO;
import com.digiwin.athena.atmc.http.restful.bpm.model.BpmTaskPreApproveRequestDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class TaskEngineServiceImpl
implements TaskEngineService {
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public List<Map> getForeCastTask(String taskUid) {
        return this.getForeCastTaskAndPlanEndTime(taskUid, null);
    }

    @Override
    public List<Map> getForeCastTaskAndPlanEndTime(String taskUid, String newPlanEndTime) {
        List result = null;
        String locale = "";
        if ("SIMPLIFIED_CHINESE".equals(this.envProperties.getDefaultLanguage())) {
            locale = "zh_CN";
        } else if ("TRADITIONAL_CHINESE".equals(this.envProperties.getDefaultLanguage())) {
            locale = "zh_TW";
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("taskUid", taskUid);
        paramMap.put("locale", locale);
        if (StringUtils.isNotEmpty((String)newPlanEndTime)) {
            paramMap.put("planEndTime", newPlanEndTime);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String getAppIdUrl = this.envProperties.getTaskEngineUrl() + "api/task/forecast";
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        ResponseEntity appIdResponse = this.restTemplate.exchange(getAppIdUrl, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Map>>>(){}, new Object[0]);
        if (appIdResponse.getStatusCode() == HttpStatus.OK) {
            result = (List)((BaseResultDTO)appIdResponse.getBody()).getResponse();
        }
        return result;
    }

    @Override
    public void reassignManualTask(String workitemId, String oldPerformerId, String newPerformerId, String comment) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("workitemId", workitemId);
        paramMap.put("performerId", oldPerformerId);
        paramMap.put("performerType", 0);
        paramMap.put("newPerformerId", newPerformerId);
        paramMap.put("comment", comment);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String serviceUri = this.envProperties.getTaskEngineUrl() + "api/task/manual/reassign";
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        this.restTemplate.postForEntity(serviceUri, (Object)httpEntity, Map.class, new Object[0]);
    }

    @Override
    public void reassignApproveTask(String workitemId, String oldPerformerId, String newPerformerId, String comment) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("workitemId", workitemId);
        paramMap.put("performerId", oldPerformerId);
        paramMap.put("performerType", 0);
        paramMap.put("newPerformerId", newPerformerId);
        paramMap.put("comment", comment);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String serviceUri = this.envProperties.getTaskEngineUrl() + "api/task/approve/work/reassign";
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        this.restTemplate.postForEntity(serviceUri, (Object)httpEntity, Map.class, new Object[0]);
    }

    @Override
    public void dispatchTask(String workitemId, String performerId, String comment) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("workitemId", workitemId);
        paramMap.put("performerId", performerId);
        paramMap.put("performerType", 0);
        paramMap.put("comment", comment);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String serviceUri = this.envProperties.getTaskEngineUrl() + "api/task/manual/dispatch";
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        this.restTemplate.postForEntity(serviceUri, (Object)httpEntity, Map.class, new Object[0]);
    }

    @Override
    public void addWorkitem(String bpmActivityOID, String performerId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("activityUid", bpmActivityOID);
        paramMap.put("performerId", performerId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String serviceUri = this.envProperties.getTaskEngineUrl() + "api/task/manual/workitem/add";
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        this.restTemplate.postForEntity(serviceUri, (Object)httpEntity, Map.class, new Object[0]);
    }

    @Override
    public List<BpmTaskApproveActivityDTO> queryApproveByTaskUid(BpmTaskApproveRequestDTO requestDTO) {
        List result = null;
        String url = this.envProperties.getTaskEngineUrl() + "api/task/approve/process";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> rootPara = new HashMap<String, String>();
        rootPara.put("locale", requestDTO.getLocale());
        rootPara.put("taskUid", requestDTO.getTaskUid());
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<BpmTaskApproveActivityDTO>>>(){}, rootPara);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result == null ? new ArrayList() : result;
    }

    @Override
    public BpmTaskApprovePreviousActivityDTO queryPreApprove(BpmTaskPreApproveRequestDTO requestDTO) {
        BpmTaskApprovePreviousActivityDTO result = null;
        String url = this.envProperties.getPtmUri() + "api/task/approve/work/previous-activities";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> rootPara = new HashMap<String, String>();
        rootPara.put("locale", requestDTO.getLocale());
        rootPara.put("workitemId", requestDTO.getWorkitemId());
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<BpmTaskApprovePreviousActivityDTO>>(){}, rootPara);
        result = (BpmTaskApprovePreviousActivityDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result == null ? new BpmTaskApprovePreviousActivityDTO() : result;
    }

    @Override
    public void batchTerminateTask(List<String> taskUids) {
        String url = this.envProperties.getTaskEngineUrl() + "api/task/terminate";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<String>> rootPara = new HashMap<String, List<String>>();
        rootPara.put("taskUids", taskUids);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, rootPara);
        ((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
    }

    @Override
    public void batchChangePersonInCharge(String personInCharge, String personInChargeName, List<String> processSerialNumberList) {
        String url = this.envProperties.getTaskEngineUrl() + "api/project/detail/in-charge/batch";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("personInCharge", personInCharge);
        rootPara.put("personInChargeName", personInChargeName);
        rootPara.put("serialNumberList", processSerialNumberList);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, rootPara);
        ((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
    }
}

