/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.eoc.impl;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.eoc.EocService;
import com.digiwin.athena.atmc.http.restful.eoc.model.EocBaseDTO;
import com.digiwin.athena.atmc.http.restful.eoc.model.EocDeptDTO;
import com.digiwin.athena.atmc.http.restful.eoc.model.EocDeptEmployeeDTO;
import com.digiwin.athena.atmc.http.restful.eoc.model.EocDirectEmployeeDTO;
import com.digiwin.athena.atmc.http.restful.eoc.model.EocDutyEmployeeDTO;
import com.digiwin.athena.atmc.http.restful.eoc.model.EocEmployeeDTO;
import com.digiwin.athena.atmc.http.restful.eoc.model.EocResultDTO;
import com.digiwin.athena.atmc.http.restful.eoc.model.EocTenantAllUserDTO;
import com.digiwin.athena.atmc.http.restful.eoc.model.EocUserDeptDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.BizUnitInfoDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.BizUnitInfoRespDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.EocUserDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.EocUserDTOWithCode;
import com.digiwin.athena.atmc.http.restful.iam.model.EocUserListDTOWithCode;
import com.digiwin.athena.atmc.http.restful.iam.model.ProxyUserDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.ProxyUserDTOListWithCode;
import com.digiwin.athena.atmc.http.restful.iam.model.ProxyUserDTOWithCode;
import com.digiwin.athena.atmc.http.restful.iam.model.TenantBizUnitDTO;
import com.digiwin.athena.atmc.http.util.BatchDataOperation;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class EocServiceImpl
implements EocService {
    private static final Logger log = LoggerFactory.getLogger(EocServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public EocEmployeeDTO getEmployeeByUserId(String userId) {
        return this.getEmployee(userId, null);
    }

    @Override
    public EocEmployeeDTO getEmployeeByEmpId(String empId) {
        return this.getEmployee(null, empId);
    }

    private EocEmployeeDTO getEmployee(String userId, String empId) {
        String uri = this.envProperties.getEocUri() + "api/eoc/v2/emp/info";
        HttpHeaders headers = this.getHeaders();
        this.addLang(headers);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("userId", userId);
        param.put("empId", empId);
        param.put("showException", false);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, EocResultDTO.class, new HashMap());
            EocResultDTO result = (EocResultDTO)responseEntity.getBody();
            if (result != null) {
                if (result.isSuccess()) {
                    return (EocEmployeeDTO)JsonUtils.jsonToObject((String)JSONObject.fromObject((Object)result.getData()).toString(), EocEmployeeDTO.class);
                }
                log.warn(result.getMessage());
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public List<EocDeptEmployeeDTO> getDepartEmployees(String deptId) {
        String uri = this.envProperties.getEocUri() + "api/eoc/v2/dept/emps";
        HttpHeaders headers = this.getHeaders();
        this.addLang(headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("deptId", deptId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, EocResultDTO.class, new HashMap());
        EocResultDTO result = (EocResultDTO)responseEntity.getBody();
        if (result != null && result.isSuccess()) {
            return (List)JsonUtils.jsonToObject((String)JSONArray.fromObject((Object)result.getData()).toString(), (TypeReference)new TypeReference<List<EocDeptEmployeeDTO>>(){});
        }
        return null;
    }

    @Override
    public List<EocDutyEmployeeDTO> getDutyEmployees(String dutyId, String deptId, String empContent) {
        String uri = this.envProperties.getEocUri() + "api/eoc/v2/duty/emps";
        HttpHeaders headers = this.getHeaders();
        this.addLang(headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", dutyId);
        param.put("deptId", deptId);
        param.put("empContent", empContent);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, EocResultDTO.class, new HashMap());
        EocResultDTO result = (EocResultDTO)responseEntity.getBody();
        if (result != null && result.isSuccess()) {
            return (List)JsonUtils.jsonToObject((String)JSONArray.fromObject((Object)result.getData()).toString(), (TypeReference)new TypeReference<List<EocDutyEmployeeDTO>>(){});
        }
        return null;
    }

    @Override
    public EocDirectEmployeeDTO getDirectorEmployee(String deptId) {
        String uri = this.envProperties.getEocUri() + "/api/eoc/v2/dept/director";
        HttpHeaders headers = this.getHeaders();
        this.addLang(headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("deptId", deptId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, EocResultDTO.class, new HashMap());
        EocResultDTO result = (EocResultDTO)responseEntity.getBody();
        if (result != null && result.isSuccess()) {
            return (EocDirectEmployeeDTO)JsonUtils.jsonToObject((String)JSONObject.fromObject((Object)result.getData()).toString(), EocDirectEmployeeDTO.class);
        }
        return null;
    }

    @Override
    public EocDirectEmployeeDTO getDirectorEmployee(String deptId, String companyId) {
        String uri = this.envProperties.getEocUri() + "/api/eoc/v2/dept/director";
        HttpHeaders headers = this.getHeaders();
        this.addLang(headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("deptId", deptId);
        param.put("companyId", companyId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, EocResultDTO.class, new HashMap());
        EocResultDTO result = (EocResultDTO)responseEntity.getBody();
        if (result != null && result.isSuccess()) {
            return (EocDirectEmployeeDTO)JsonUtils.jsonToObject((String)JSONObject.fromObject((Object)result.getData()).toString(), EocDirectEmployeeDTO.class);
        }
        return null;
    }

    @Override
    public List<EocTenantAllUserDTO.EocUserDTO> getAllUserByTenant() {
        String uri = this.envProperties.getEocUri() + "api/eoc/v2/emp?pageNum=1&pageSize=9999";
        HttpHeaders headers = this.getHeaders();
        this.addLang(headers);
        HashMap param = new HashMap();
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, EocTenantAllUserDTO.class, new HashMap());
        EocTenantAllUserDTO result = (EocTenantAllUserDTO)responseEntity.getBody();
        if (result != null && result.isSuccess()) {
            return result.getData().getList();
        }
        return Collections.emptyList();
    }

    @Override
    public List<EocTenantAllUserDTO.EocUserDTO> getAllUserByParams(Map<String, Object> eocParams) {
        String uri = this.envProperties.getEocUri() + "api/eoc/v2/emp?";
        HashMap<String, String> param = new HashMap<String, String>();
        if (MapUtils.isNotEmpty(eocParams)) {
            for (String key : eocParams.keySet()) {
                uri = uri + key + "={" + key + "}&";
                param.put(key, JsonUtils.objectToString((Object)eocParams.get(key)));
            }
            uri = uri.substring(0, uri.length() - 1);
        }
        HttpHeaders headers = this.getHeaders();
        this.addLang(headers);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, EocTenantAllUserDTO.class, param);
        EocTenantAllUserDTO result = (EocTenantAllUserDTO)responseEntity.getBody();
        if (result != null && result.isSuccess()) {
            return result.getData().getList();
        }
        return Collections.emptyList();
    }

    @Override
    public EocDirectEmployeeDTO getDirectorEmployeeByUserId(String userId) {
        String uri = this.envProperties.getEocUri() + "/api/eoc/v2/emp/director";
        HttpHeaders headers = this.getHeaders();
        this.addLang(headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, EocResultDTO.class, new HashMap());
        EocResultDTO result = (EocResultDTO)responseEntity.getBody();
        if (result != null && result.isSuccess()) {
            return (EocDirectEmployeeDTO)JsonUtils.jsonToObject((String)JSONObject.fromObject((Object)result.getData()).toString(), EocDirectEmployeeDTO.class);
        }
        return null;
    }

    @Override
    public Boolean isDeptDirector(String userId) {
        List<EocTenantAllUserDTO.EocUserDTO> eocUserDTOList = this.getAllUserByDirectorId(userId, 1);
        if (CollectionUtils.isNotEmpty(eocUserDTOList)) {
            return Boolean.TRUE;
        }
        EocEmployeeDTO eocEmployeeDTO = this.getEmployeeByUserId(userId);
        if (eocEmployeeDTO != null && CollectionUtils.isNotEmpty(eocEmployeeDTO.getDepts())) {
            for (EocEmployeeDTO.EocEmployeeDepartDTO dept : eocEmployeeDTO.getDepts()) {
                if (!Objects.equals(dept.getDeptDirectorId(), eocEmployeeDTO.getId())) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    @Override
    public List<EocDeptEmployeeDTO> getDeptDirectorEmployees(String userId) {
        ArrayList<EocDeptEmployeeDTO> result = new ArrayList<EocDeptEmployeeDTO>();
        EocEmployeeDTO eocEmployeeDTO = this.getEmployeeByUserId(userId);
        if (eocEmployeeDTO == null || CollectionUtils.isEmpty(eocEmployeeDTO.getDepts())) {
            return result;
        }
        for (EocEmployeeDTO.EocEmployeeDepartDTO dept : eocEmployeeDTO.getDepts()) {
            List<EocDeptEmployeeDTO> list;
            if (!Objects.equals(dept.getDeptDirectorId(), eocEmployeeDTO.getId()) || !CollectionUtils.isNotEmpty(list = this.getDepartEmployees(dept.getId()))) continue;
            for (EocDeptEmployeeDTO eocDeptEmployeeDTO : list) {
                if (org.springframework.util.StringUtils.isEmpty((Object)eocDeptEmployeeDTO.getUserId()) || result.stream().filter(x -> Objects.equals(x.getUserId(), eocDeptEmployeeDTO.getUserId())).count() != 0L) continue;
                result.add(eocDeptEmployeeDTO);
            }
        }
        return result;
    }

    @Override
    public List<EocTenantAllUserDTO.EocUserDTO> getAllUserByDirectorId(String directorId, Integer size) {
        EocEmployeeDTO eocEmployeeDTO = this.getEmployeeByUserId(directorId);
        if (eocEmployeeDTO == null) {
            return null;
        }
        String uri = this.envProperties.getEocUri() + "api/eoc/v2/emp/simple?pageNum=1&pageSize={pageSize}&params={params}";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("directorId", eocEmployeeDTO.getId());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("pageSize", size.toString());
        param.put("params", JsonUtils.objectToString(params));
        HttpHeaders headers = this.getHeaders();
        this.addLang(headers);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, EocTenantAllUserDTO.class, param);
        EocTenantAllUserDTO result = (EocTenantAllUserDTO)responseEntity.getBody();
        if (result != null && result.isSuccess()) {
            return result.getData().getList();
        }
        return null;
    }

    @Override
    public List<EocTenantAllUserDTO.EocUserDTO> getEmployeeInfoByUserId(Collection<String> userIds) {
        ArrayList<EocTenantAllUserDTO.EocUserDTO> employeeInfoList = new ArrayList<EocTenantAllUserDTO.EocUserDTO>();
        BatchDataOperation<ArrayList> batchDataOperation = new BatchDataOperation<ArrayList>(Lists.newArrayList(userIds));
        batchDataOperation.batchOperate(tmpUserIds -> employeeInfoList.addAll(this.getBatchEmployeeInfo(tmpUserIds)), 50);
        return employeeInfoList;
    }

    private List<EocTenantAllUserDTO.EocUserDTO> getBatchEmployeeInfo(List<String> userIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userIds", userIds);
        EocTenantAllUserDTO queryEmpInfo = this.queryEmpInfo(null, null, null, params);
        if (null != queryEmpInfo && null != queryEmpInfo.getData()) {
            return queryEmpInfo.getData().getList();
        }
        return Collections.emptyList();
    }

    private EocTenantAllUserDTO queryEmpInfo(Integer pageNum, Integer pageSize, String orderBy, Map<String, Object> params) {
        String url = this.envProperties.getEocUri() + "api/eoc/v2/emp/simple?pageNum={pageNum}&pageSize={pageSize}&orderBy={orderBy}&params={params}";
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("pageNum", null != pageNum ? pageNum : 1);
        uriVariables.put("pageSize", null != pageSize ? pageSize : Integer.MAX_VALUE);
        uriVariables.put("orderBy", orderBy);
        uriVariables.put("params", JsonUtils.objectToString((Object)(null != params ? params : new HashMap())));
        HttpHeaders headers = this.getHeaders();
        this.addLang(headers);
        HttpEntity reqEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, reqEntity, EocTenantAllUserDTO.class, uriVariables);
            return (EocTenantAllUserDTO)respEntity.getBody();
        }
        catch (Exception ex) {
            log.error("\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}\uff0c\u9519\u8bef\u5185\u5bb9\uff1a{}", uriVariables, (Object)ex.getMessage());
            throw ExceptionUtil.wrap((String)ErrorCodeEnum.EOC_SEARCH_STAFF_INFO_FAIL.getErrCode(), (Exception)ex);
        }
    }

    @Override
    public List<EocDeptEmployeeDTO> getUserByDirectorId(String userId) {
        List<EocTenantAllUserDTO.EocUserDTO> eocUserDTOList;
        List<EocDeptEmployeeDTO> eocDeptEmployeeDTOList = this.getDeptDirectorEmployees(userId);
        if (eocDeptEmployeeDTOList == null) {
            eocDeptEmployeeDTOList = new ArrayList<EocDeptEmployeeDTO>();
        }
        if (CollectionUtils.isEmpty(eocUserDTOList = this.getAllUserByDirectorId(userId, 2000))) {
            return eocDeptEmployeeDTOList;
        }
        for (EocTenantAllUserDTO.EocUserDTO eocUserDTO : eocUserDTOList) {
            if (eocDeptEmployeeDTOList.stream().filter(x -> Objects.equals(x.getUserId(), eocUserDTO.getUserId())).count() != 0L) continue;
            EocDeptEmployeeDTO eocUser = EocDeptEmployeeDTO.builder().userId(eocUserDTO.getUserId()).userName(eocUserDTO.getUserName()).empId(eocUserDTO.getId()).empName(eocUserDTO.getName()).deptId(eocUserDTO.getDeptId()).deptName(eocUserDTO.getDeptName()).status(eocUserDTO.getStatus()).build();
            eocDeptEmployeeDTOList.add(eocUser);
        }
        return eocDeptEmployeeDTOList;
    }

    @Override
    public List<EocDeptDTO.Dept> queryAllDeptAndEmployee() {
        List<EocDeptDTO.Dept> result = new ArrayList<EocDeptDTO.Dept>();
        String uri = this.envProperties.getEocUri() + "api/eoc/v2/dept/cascade?pageNum=1&pageSize={pageSize}";
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("pageSize", 2000);
        HttpHeaders headers = this.getHeaders();
        this.addLang(headers);
        try {
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, EocDeptDTO.class, params);
            EocDeptDTO body = (EocDeptDTO)responseEntity.getBody();
            if (body != null && body.isSuccess() && body.getData() != null) {
                result = body.getData().getList();
            }
            return result;
        }
        catch (Exception ex) {
            log.error(ErrorCodeEnum.EOC_SEARCH_EOC_V2_DEPT_CASCADE_FAIL.getErrMsg() + "\uff0c\u53c2\u6570\uff1a{}\uff0c\u9519\u8bef\u5185\u5bb9\uff1a{}", params, (Object)ex.getMessage());
            throw ExceptionUtil.wrap((String)ErrorCodeEnum.EOC_SEARCH_STAFF_INFO_FAIL.getErrCode(), (Exception)ex);
        }
    }

    @Override
    public JSONArray queryMembersOfTheDepartment(String departmentSid) {
        String uri = this.envProperties.getEocUri() + "api/eoc/v2/dept/{departmentSid}/emps?pageNum=1&pageSize={pageSize}";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("departmentSid", departmentSid);
        params.put("pageSize", 2000);
        HttpHeaders headers = this.getHeaders();
        this.addLang(headers);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, EocResultDTO.class, params);
        EocResultDTO result = (EocResultDTO)responseEntity.getBody();
        if (result != null && result.isSuccess()) {
            return JSONArray.fromObject(((LinkedHashMap)result.getData()).get("list"));
        }
        return new JSONArray();
    }

    @Override
    public JSONArray queryCurrentTenantAllDepartment() {
        String uri = this.envProperties.getEocUri() + "api/eoc/v2/dept/list?pageNum=1&pageSize={pageSize}";
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("pageSize", 2000);
        HttpHeaders headers = this.getHeaders();
        this.addLang(headers);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, EocResultDTO.class, params);
        EocResultDTO result = (EocResultDTO)responseEntity.getBody();
        if (result != null && result.isSuccess()) {
            return JSONArray.fromObject(((LinkedHashMap)result.getData()).get("list"));
        }
        return new JSONArray();
    }

    @Override
    public JSONArray queryUserDepartmentInfo(String userId) {
        String uri = this.envProperties.getEocUri() + "api/eoc/v2/emp/subordinate";
        HttpHeaders headers = this.getHeaders();
        this.addLang(headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, EocResultDTO.class, new HashMap());
        EocResultDTO result = (EocResultDTO)responseEntity.getBody();
        if (result != null && result.isSuccess()) {
            return JSONArray.fromObject((Object)result.getData());
        }
        return new JSONArray();
    }

    private HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return headers;
    }

    private void addLang(HttpHeaders headers) {
        headers.add("locale", LocaleContextHolder.getLocale().toString());
    }

    @Override
    public String getEmpIdByUserId(String userId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getEocUri() + "/api/eoc/v2/emp/id";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        Map body = (Map)responseEntity.getBody();
        if (body == null) {
            return null;
        }
        return body.get("data").toString();
    }

    @Override
    public String getUserIdByEmpId(String empId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("empId", empId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getEocUri() + "/api/eoc/v2/emp/user/id";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        Map body = (Map)responseEntity.getBody();
        if (body == null) {
            return null;
        }
        return body.get("data").toString();
    }

    @Override
    public ProxyUserDTO getProxyUser(String userId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        param.put("agentDate", df.format(LocalDateTime.now()));
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getEocUri() + "api/eoc/v2/emp/agent";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ProxyUserDTOWithCode.class, new Object[0]);
        ProxyUserDTOWithCode baseResult = (ProxyUserDTOWithCode)responseEntity.getBody();
        if (baseResult.getCode() == 200 && baseResult.getData() != null) {
            return baseResult.getData();
        }
        return null;
    }

    @Override
    public List<ProxyUserDTO> getProxyTargetUsers(String userId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getEocUri() + "api/eoc/v2/emp/agent/target";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ProxyUserDTOListWithCode.class, new Object[0]);
        ProxyUserDTOListWithCode baseResult = (ProxyUserDTOListWithCode)responseEntity.getBody();
        if (baseResult != null && baseResult.getCode() == 200 && baseResult.getData() != null) {
            return baseResult.getData();
        }
        return null;
    }

    @Override
    public List<EocUserDTO> getEocUserListByUserId(String userId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getEocUri() + "api/eoc/v2/dept/main/emps";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, EocUserListDTOWithCode.class, new Object[0]);
        EocUserListDTOWithCode baseResult = (EocUserListDTOWithCode)responseEntity.getBody();
        if (baseResult.getCode() == 200) {
            return baseResult.getData();
        }
        return null;
    }

    @Override
    public EocUserDTO getUserLeader(String userId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getEocUri() + "/api/eoc/v2/emp/director";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, EocUserDTOWithCode.class, new Object[0]);
        EocUserDTOWithCode baseResult = (EocUserDTOWithCode)responseEntity.getBody();
        if (baseResult.getCode() == 200) {
            return baseResult.getData();
        }
        return null;
    }

    @Override
    public EocUserDTO getDeptLeader(String deptId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("deptId", deptId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getEocUri() + "/api/eoc/v2/dept/director";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, EocUserDTOWithCode.class, new Object[0]);
        EocUserDTOWithCode baseResult = (EocUserDTOWithCode)responseEntity.getBody();
        if (baseResult.getCode() == 200) {
            return baseResult.getData();
        }
        return null;
    }

    @Override
    public String getEocByTenantAndUser(AuthoredUser user, String tenantSid, String userId) {
        if (StringUtils.isEmpty((String)tenantSid) || StringUtils.isEmpty((String)userId)) {
            return "";
        }
        String eocUserId = "";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", user.getToken());
        String url = this.envProperties.getEocUri() + "/api/eoc/v2/emp/tenant/user/id/info";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantSid", tenantSid);
        paramMap.put("userId", userId);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                JSONObject jsonObject = JSONObject.fromObject(((Map)response.getBody()).get("data"));
                eocUserId = jsonObject.getString("id");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return eocUserId;
    }

    @Override
    public String getEocEmpInfo(String userId, AuthoredUser user) {
        String eocEmpId = "";
        EocEmployeeDTO employee = this.getEmployee(userId, null);
        if (Objects.isNull(employee)) {
            return eocEmpId;
        }
        return employee.getId();
    }

    @Override
    public BizUnitInfoDTO getBizUnitInfo(JSONObject bizUnitCodeJSONObj) {
        BizUnitInfoDTO reqBody = new BizUnitInfoDTO();
        if (!bizUnitCodeJSONObj.containsKey((Object)"eoc_company_id")) {
            return reqBody;
        }
        String companyId = bizUnitCodeJSONObj.getString("eoc_company_id");
        if (StringUtils.isBlank((String)companyId)) {
            return reqBody;
        }
        reqBody.setCompanyId(companyId);
        if (bizUnitCodeJSONObj.containsKey((Object)"eoc_site_id")) {
            reqBody.setFactoryId(bizUnitCodeJSONObj.getString("eoc_site_id"));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)reqBody, (MultiValueMap)headers);
        String url = this.envProperties.getEocUri() + "api/eoc/v2/corp/company/factory/name";
        try {
            ResponseEntity respEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, BizUnitInfoRespDTO.class, new Object[0]);
            if (respEntity.getStatusCode() == HttpStatus.OK) {
                BizUnitInfoDTO bizUnitInfoDTO = Optional.ofNullable(respEntity.getBody()).map(BizUnitInfoRespDTO::getData).orElse(null);
                if (null != bizUnitInfoDTO && StringUtils.isNotBlank((String)bizUnitInfoDTO.getCompanyName())) {
                    return bizUnitInfoDTO;
                }
                log.warn("[BizUnitInfoDTO getBizUnitInfo] Can't get valid info for {}", (Object)JsonUtils.objectToString((Object)reqBody));
                return reqBody;
            }
            return new BizUnitInfoDTO();
        }
        catch (Exception ex) {
            return new BizUnitInfoDTO();
        }
    }

    @Override
    public TenantBizUnitDTO getCompanyInfoForTenant() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap param = new HashMap();
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getEocUri() + "api/eoc/v2/corp/company";
        ResponseEntity respEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, TenantBizUnitDTO.class, new Object[0]);
        return (TenantBizUnitDTO)respEntity.getBody();
    }

    @Override
    public TenantBizUnitDTO getFactoryInfoForTenant() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap param = new HashMap();
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getEocUri() + "api/eoc/v2/corp/factory";
        ResponseEntity respEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, TenantBizUnitDTO.class, new Object[0]);
        return (TenantBizUnitDTO)respEntity.getBody();
    }

    public static void main(String[] args) {
        HashMap respEntity = new HashMap();
        System.out.println(respEntity.get("1"));
    }

    @Override
    public List<EocUserDeptDTO.EocUserDept> getDeptByUserId(String userId, Integer size) {
        String uri = this.envProperties.getEocUri() + "api/eoc/v2/emp/simple?pageNum=1&pageSize={pageSize}&params={params}";
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("userIds", Arrays.asList(userId));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("pageSize", size.toString());
        param.put("params", JsonUtils.objectToString(params));
        HttpHeaders headers = this.getHeaders();
        this.addLang(headers);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, EocUserDeptDTO.class, param);
        EocUserDeptDTO result = (EocUserDeptDTO)responseEntity.getBody();
        if (result != null && result.isSuccess()) {
            return result.getData().getList();
        }
        return null;
    }

    @Override
    public List<EocEmployeeDTO> getEmployees(List<String> userIds, List<String> empIds) {
        String uri = this.envProperties.getEocUri() + "api/eoc/v2/emp/infos";
        HttpHeaders headers = this.getHeaders();
        this.addLang(headers);
        HashMap<String, List<String>> param = new HashMap<String, List<String>>();
        param.put("userIds", userIds);
        param.put("empIds", empIds);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<EocBaseDTO<List<EocEmployeeDTO>>>(){}, new HashMap());
            EocBaseDTO result = (EocBaseDTO)responseEntity.getBody();
            if (result != null) {
                if (result.isSuccess()) {
                    return (List)((EocBaseDTO)responseEntity.getBody()).getData();
                }
                log.warn(result.getMessage());
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

