package com.digiwin.athena.atmc.http.constant;

/**
 * @Author wuzq
 * @Date 2023/6/8 16:08
 * @Description: atdm API
 * @Version 1.0
 */
public class AtdmApiConstant {

    private AtdmApiConstant() {
    }

    /**
     * 提交
     */
    public static final String ACTION_SUBMIT_TASK = "api/atdm/v1/action/submit/task";

    /**
     * 执行
     */
    public static final String ACTION_EXECUTE = "api/atdm/v1/action/execute";

    /**
     * 根据actionId查询
     */
    public static final String DATA_QUERY_BY_ACTION_ID = "api/atdm/v1/data/query/by/actionId";

    /**
     * 提交合并的任务
     */
    public static final String ACTION_SUBMIT_MERGE_TASK = "api/atdm/v1/action/submit/mergeTask";

    /**
     * 提交合并的任务支持跨BK
     */
    public static final String ACTION_SUBMIT_MERGE_TASK_CROSS_BK = "api/atdm/v1/action/submit/mergeTaskCrossBk";

    /**
     * 将回收站记录标记为过期状态
     */
    public static final String RECYCLE_STATE_EXPIRED = "api/atdm/v1/recycle/state/expired";

    /**
     * 将回收站记录标记为未过期状态
     */
    public static final String RECYCLE_STATE_UNEXPIRED = "api/atdm/v1/recycle/state/unexpired";

    /**
     * 将回收站记录标记为删除状态（硬删除）
     */
    public static final String RECYCLE_STATE_DELETED = "api/atdm/v1/recycle/state/deleted";

    /**
     * 获取任务卡CheckItems等数
     */
    public static final String DATA_QUERY_BY_ACTION = "api/atdm/v1/data/query/by/action";

    /**
     * 退回
     */
    public static final String ACTION_SUBMIT_RETURN_MERGE_TASK = "api/atdm/v1/action/submit/returnTask";


    /**
     * 根据数据源获取应用业务数据
     */
    public static final String WITH_META_DATA= "api/atdm/v1/data/query/by/backlog/withmetadata";

    /**
     * 合并的任务重试
     */
    public static final String ACTION_SUBMIT_MERGE_TASK_RETRY = "api/atdm/v1/action/submit/mergeTaskRetry";
}
