package com.digiwin.athena.atmc.http.restful.atdm.model;

import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * Description TODO
 * Author hebaokai
 * Date 2024/2/19 14:35
 *
 * @Version 1.0
 **/
@Data
public class QueryResult {

    /**
     * 数据节点名称
     */
    private String dataSourceName;

    /**
     * 数据结果集合
     */
    private List<Map<String, Object>> data;

    private ApiMetadataCollection apiMetadataCollection;
    private List<ApiMetadataCollection> apiMetadataCollectionList;

    private Map<String, Integer> dataKeyIndex;
    /**
     * 数据的key字段
     */
    private List<String> dataKeys;




    public String getDataSourceName() {
        if (dataSourceName == null) {
            if (this.apiMetadataCollection != null
                    && this.apiMetadataCollection.getMasterApiMetadata() != null
                    && CollectionUtils.isNotEmpty(this.apiMetadataCollection.getMasterApiMetadata().getResponseFields())) {
                dataSourceName = this.apiMetadataCollection.getMasterApiMetadata().getResponseFields().get(0).get("name").toString();
            } else {
                dataSourceName = "data";
            }
        }
        return dataSourceName;
    }
}
