package com.digiwin.athena.atmc.http.restful.cac.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.http.constant.CacApiConstant;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.cac.CacService;
import com.digiwin.athena.atmc.http.restful.cac.model.AppAuthDTO;
import com.digiwin.athena.atmc.http.restful.cac.model.BaseCacResult;
import com.digiwin.athena.atmc.http.restful.cac.model.UserAppDTO;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Service
public class CacServiceImpl implements CacService {

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    MessageUtils messageUtils;

    /**
     * 检查指定用户的指定应用 在当前租户是否有授权
     *
     * @param userId
     * @param appCode
     * @return
     */
    @Override
    public AppAuthDTO queryAppAuth(String userId, String appCode) {
        AppAuthDTO result = null;

        String uri = envProperties.getIamCacUri()
            + CacApiConstant.AUTHORIZATIONS_CURRENT_TENANT_USERS_USER_ID_GOODS_APP_CODE_BY_USER;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        Map<String, String> param = new HashMap<>();
        param.put("userId", userId);
        param.put("appCode", appCode);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        ResponseEntity<AppAuthDTO> responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
            new ParameterizedTypeReference<AppAuthDTO>() {
            }, param);
        result = responseEntity.getBody();
        return result;
    }

    @Override
    public List<UserAppDTO> qryUserApp() {

        String uri = envProperties.getIamCacUri() + CacApiConstant.AUTHORIZATIONS_CURRENT_USER_APPS;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        try {
            ResponseEntity<BaseCacResult<List<UserAppDTO>>> responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
                new ParameterizedTypeReference<BaseCacResult<List<UserAppDTO>>>() {
                });
            if (null != responseEntity.getBody() && String.valueOf(HttpStatus.OK.value()).equals(responseEntity.getBody().getCode())){
                return responseEntity.getBody().getData();
            }
        }
        catch (Exception e) {
            log.error("execute cac [/authorizations/current/user/apps] fail, message = {}", e.getMessage());
        }
        return null;
    }


    @Override
    public List<String> queryUserByAppCode(String appCode){

        String uri = envProperties.getIamCacUri() + CacApiConstant.COUNTING_CURRENT_TENANT_GOODS_GOODS_CODE;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        Map<String, String> param = new HashMap<>();
        param.put("goodsCode", appCode);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        try{
            ResponseEntity<List<String>> responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<List<String>>() {
                    }, param);
            return responseEntity.getBody();
        }
        catch (Exception e){
            log.error("execute cac [/counting/currenttenant/goods/{goodsCode}] fail, message = {}", e.getMessage());
        }
        return new ArrayList<>();
    }

    @Override
    public List<UserAppDTO> qryUserAppByUserId(String userId) {

        String uri = envProperties.getIamCacUri() + CacApiConstant.AUTHORIZATIONS_CURRENT_USER_APPS_BY_USER_ID;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //入参
        Map<String, Object> param = new HashMap<>();
        param.put("userId", userId);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        try {
            ResponseEntity<BaseCacResult<List<UserAppDTO>>> responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseCacResult<List<UserAppDTO>>>() {
                    }, param);
            if (null != responseEntity.getBody() && String.valueOf(HttpStatus.OK.value()).equals(responseEntity.getBody().getCode())){
                return responseEntity.getBody().getData();
            }
        }
        catch (Exception e) {
            log.error("execute cac [/authorizations/current/user/apps] fail, message = {}", e.getMessage());
        }
        return null;
    }

}
