package com.digiwin.athena.atmc.http.restful.emc.impl;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.http.constant.EmcApiConstant;
import com.digiwin.athena.atmc.http.constant.GlobalConstant;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.util.AtmcStrUtil;
import com.digiwin.athena.atmc.http.restful.emc.model.AppMessageDTO;
import com.digiwin.athena.atmc.http.restful.emc.EmcService;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class EmcServiceImpl implements EmcService {

    @Autowired
    private EnvProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    MessageUtils messageUtils;

    @Override
    public void pushMessage(String token, AppMessageDTO appMessageDTO) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, token);
        HttpEntity<?> httpEntity = new HttpEntity<>(appMessageDTO, headers);
        String url = envProperties.getEmcUri() + EmcApiConstant.MESSAGE_PUSH;

        try {
            ResponseEntity<HashMap> roleResponseEntity = restTemplate.postForEntity(url, httpEntity, HashMap.class);
            if (roleResponseEntity.getBody() == null) {
                HashMap result = roleResponseEntity.getBody();
                if (null != result && result.get("code") != null) {
                    String code = result.get("code").toString();
                    if (!"200".equals(code)) {
                        throw BusinessException.create(ErrorCodeEnum.EMC_MESSAGE_PUSH.getErrCode(), result.get("message").toString());
                    }
                }
            }
        } catch (Exception ex) {
            log.error("{}, 请求body体：{}, 报错信息：{}", ErrorCodeEnum.EMC_MESSAGE_PUSH.getErrCode(), JsonUtils.objectToString(appMessageDTO), ex);
            throw ExceptionUtil.wrap(ErrorCodeEnum.EMC_MESSAGE_PUSH.getErrCode(), ex);
        }
    }

    /**
     * emc-notice settings
     * 主要是用于取邮件预览
     *
     * @param
     * @return
     */
    public List<Map<String, Object>> getNoticesSettings(AuthoredUser user, String previewId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());
        HttpEntity<String> reqEntity = new HttpEntity<>(null, headers);
        String url = envProperties.getEmcUri() + AtmcStrUtil.format(EmcApiConstant.NOTICES_SETTINGS_ID_PREVIEW_ID, previewId);
        try {
            ResponseEntity<List> noticeResp = restTemplate.exchange(url, HttpMethod.GET, reqEntity, List.class);
            if (noticeResp.getStatusCode() == HttpStatus.OK && noticeResp.getBody() == null) {
                return new ArrayList<>();
            } else {
                return (List<Map<String, Object>>) noticeResp.getBody();
            }
        } catch (Exception ex) {
            log.error("{}, url：{}, 报错信息：{}", ErrorCodeEnum.EMC_GET_NOTICE_SETTINGS_FAIL.getErrCode(), url, ex);
            throw ExceptionUtil.wrap(ErrorCodeEnum.EMC_GET_NOTICE_SETTINGS_FAIL.getErrCode(), ex);
        }
    }


}
