package com.digiwin.athena.atmc.http.restful.ptm.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Map;

/**
 * PTM 待办数据类
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PtmBacklogItemDTO {

    private Long backlogId;
    private Long workItemId;
    /**
     * 相当于 bpm_activity_step.id
     */
    private Long activityId;
    /**
     * 相当于 bpm_activity.id
     */
    private Long taskId;
    /**
     * 相当于 bpm_process.id
     */
    private Long projectId;
    /**
     * 相当于 task.id
     */
    private Long projectCardId;
    private String taskName;
    /**
     * 格式："{"zh_CN":"xxx", "zh_TW": "xxxxx", "en_US": "xxxxxx"}"
     */
    private String taskWithName;
    private String performerId;
    private String performerName;
    private Boolean exception;
    private String taskDefCode;
    private String taskDefName;
    /**
     * 格式："{"zh_CN":"xxx", "zh_TW": "xxxxx", "en_US": "xxxxxx"}"
     */
    private String taskDefWithName;
    private String taskDefCategory;
    private String taskDefPattern;
    private String taskDefExecuteType;
    private String bpmnType;
    private LocalDateTime createTime;
    private LocalDateTime planEndTime;
    private LocalDateTime closedTime;
    private String signReason;
    /**
     * workItem的状态
     */
    private Integer state;
    private Integer subState;
    /**
     * workItem所属的任务卡是否关闭。
     * closed是指任务卡是否关闭，state是workItem的状态。
     */
    private Boolean closed;
    private Map data;
    private Map businessUnit;

    /**
     * 项目状态
     */
    private Integer projectState;

    /**
     * 处理者类型0:默认;1:辅助执行者;2:跨租户;88-逾时追踪;89-数据一致性异常排除
     */
    private Integer type;
}
