/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.dap.impl;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.domain.task.SearchReqDTO;
import com.digiwin.athena.atmc.http.restful.dap.SearchService;
import com.digiwin.athena.atmc.http.restful.dap.model.SearchSuggestDTO;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class SearchServiceImpl
implements SearchService {
    private static final Logger logger = LoggerFactory.getLogger(SearchServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    private static final String DEFAULT_SUGGEST_FIELD_NAME = "name";
    private static final String DEFAULT_SUGGEST_INDEX_NAME = "completion_index";
    private static final int DEFAULT_SUGGEST_QRY_SIZE = 8;

    @Override
    public ResponseEntity<?> getSearchSuggest(SearchSuggestDTO searchSuggestDTO) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        JSONObject queryParams = new JSONObject();
        queryParams.put((Object)"prefix", (Object)searchSuggestDTO.getPrefix());
        queryParams.put((Object)"fieldName", (Object)DEFAULT_SUGGEST_FIELD_NAME);
        queryParams.put((Object)"indexName", (Object)DEFAULT_SUGGEST_INDEX_NAME);
        int size = null != searchSuggestDTO.getSize() && searchSuggestDTO.getSize() > 0 ? searchSuggestDTO.getSize() : 8;
        queryParams.put((Object)"size", (Object)size);
        HttpEntity httpEntity = new HttpEntity((Object)queryParams, (MultiValueMap)headers);
        String url = this.envProperties.getSearchUri() + "/restful/standard/Fulltext/suggester/completion";
        logger.debug("getSearchSuggest-> url:{} httpEntity: {}", (Object)url, (Object)httpEntity);
        JSONObject response = (JSONObject)this.restTemplate.postForObject(url, (Object)httpEntity, JSONObject.class, new Object[0]);
        logger.debug("getSearchSuggest-> response: {}", (Object)response);
        return this.convertSuggestQryRet(response);
    }

    private ResponseEntity<?> convertSuggestQryRet(JSONObject suggestResp) {
        int status = suggestResp.getInt("status");
        if (200 != status) {
            return ResponseEntityWrapper.wrapperFail((int)status, (String)suggestResp.getString("statusDescription"));
        }
        HashSet response = Sets.newHashSet();
        JSONArray respArray = suggestResp.getJSONArray("response");
        if (null != respArray && respArray.size() > 0) {
            for (int idx = 0; idx < respArray.size(); ++idx) {
                JSONObject respObj = respArray.getJSONObject(idx);
                if (null == respObj) continue;
                response.add(respObj.getString("text"));
            }
        }
        return ResponseEntityWrapper.wrapperOk((Object)response);
    }

    @Override
    public List<Map<String, Object>> doSearch(SearchReqDTO reqDTO) {
        ArrayList<Map<String, Object>> resp = new ArrayList<Map<String, Object>>();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        JSONObject queryInfo = new JSONObject();
        queryInfo.put((Object)"text", (Object)reqDTO.getParam());
        queryInfo.put((Object)"indexName", (Object)"mariadb-athena-*");
        JSONArray fieldNames = new JSONArray();
        fieldNames.add((Object)DEFAULT_SUGGEST_FIELD_NAME);
        fieldNames.add((Object)"target_name");
        fieldNames.add((Object)"performer_name");
        fieldNames.add((Object)"person_in_charge_name");
        queryInfo.put((Object)"fieldNames", (Object)fieldNames);
        HttpEntity httpEntity = new HttpEntity((Object)queryInfo, (MultiValueMap)headers);
        String url = this.envProperties.getSearchUri() + "/restful/standard/Fulltext/search";
        logger.debug("doSearch-> url:{} httpEntity: {}", (Object)url, (Object)httpEntity);
        JSONObject response = (JSONObject)this.restTemplate.postForObject(url, (Object)httpEntity, JSONObject.class, new Object[0]);
        JSONArray hits = response.getJSONObject("response").getJSONArray("hits");
        for (int i = 0; i < hits.size(); ++i) {
            HashMap<String, String> data = new HashMap<String, String>();
            JSONObject source = hits.getJSONObject(i).getJSONObject("_source");
            if (source != null) {
                String startTime = TimeUtils.format((LocalDateTime)TimeUtils.parse((String)source.getString("start_time")), (String)"yyyy-MM-dd HH:mm:ss").substring(5, 10).replace("-", ".");
                String endTime = TimeUtils.format((LocalDateTime)TimeUtils.parse((String)source.getString("end_time")), (String)"yyyy-MM-dd HH:mm:ss").substring(5, 10).replace("-", ".");
                if (source.get("task_id") == null) {
                    data.put("type", "task");
                    data.put("term", startTime + "-" + endTime + " " + MessageUtils.getMessageByCurrentLanguage((Object)source.getString("target_name")) + "-" + MessageUtils.getMessageByCurrentLanguage((Object)source.getString(DEFAULT_SUGGEST_FIELD_NAME)));
                } else {
                    data.put("type", "backlog");
                    data.put("term", startTime + "-" + endTime + " " + MessageUtils.getMessageByCurrentLanguage((Object)source.getString(DEFAULT_SUGGEST_FIELD_NAME)));
                }
                data.put("key", source.getString("id"));
                data.put("searchData", (String)hits.getJSONObject(i));
            }
            resp.add(data);
        }
        return resp;
    }
}

