package com.digiwin.athena.atmc.http.restful.bpm.model;

import com.digiwin.athena.atmc.http.restful.ptm.model.ApprovelAttachmentDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * BPM 任务引擎签核历程返回类型
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class BpmTaskApproveActivityDTO {

    private String bpmActivityOID;
    private String activityId;
    private String activityName;
    private String signType;
    private LocalDateTime startTime;
    private String completedTime;
    private Map informer;
    private int state;
    private int subState;
    private List<WorkItem> workitemList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class WorkItem{
        private String workitemId;
        private String agentPerformerId;
        private Integer subState;
        private LocalDateTime createTime;
        private LocalDateTime closedTime;
        private Integer createType;
        private String comment;
        private Integer state;
        private String performerId;
        private Integer performerType;
        private List<ApprovelAttachmentDTO> attachments;
    }
}
