package com.digiwin.athena.atmc.http.restful.eoc.model;

import lombok.Data;

import java.util.List;

/**
 * 获取租户下面所有人员API的返回值接口
 * api/eoc/v2/emp
 */
@Data
public class EocTenantAllUserDTO {

    private int code;
    private String message;
    private boolean success;
    private EocTenantDataDTO data;

    @Data
    public static class EocTenantDataDTO{

        private Integer total;

        private List<EocUserDTO> list;

    }

    @Data
    public static class EocUserDTO{
        private Long sid;

        /**
         * 必有字段  备注：员工id
         */
        private String id;

        /**
         * 必有字段  备注：员工名称
         */
        private String name;

        private String email;

        private Boolean status;

        /**
         * 必有字段  备注：部门id
         */
        private String deptId;

        /**
         * 必有字段  备注：部门名称
         */
        private String deptName;


        private String userId;

        private String userName;
    }
}
