package com.digiwin.athena.atmc.http.domain;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang.BooleanUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * @description: 页面相关上下文
 * @author: wangminga
 * @create: 2020-09-08 10:23
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ExecuteContext {
    /**
     * 语言别
     */
    private String locale;

    /**
     * 客户端来源
     */
    private String clientAgent;

    /**
     * 执行者performer或者当责者charge
     */
    private String identity;

    /**
     * 项目名称
     */
    private String tmProjectId;

    /**
     * 关卡名称
     */
    private String tmActivityId;

    /**
     * 关卡名称
     */
    private String tmActivityName;

    /**
     * 代理的token
     */
    private String proxyToken;
    /**
     * 登陆用户
     */
    @JsonIgnore
    private AuthoredUser authoredUser;

    /**
     * 页面场景
     * [project-card,project-detail,task-card,task-detail]
     */
    private String pageCode;


    /**
     * 短地址应用的设备类型，目前仅有email
     */
    private String deviceType;


    /**
     * 短地址应用的设备值，当deviceType为email时，表示收件人的email地址
     */
    private String deviceValue;

    /**
     * 活动形态分类
     */
    private String pattern;

    /**
     * 活动形态类型
     */
    private String category;

    /**
     * 根据标签来执行
     */
    private RelationTag relationTag;

    /**
     * 租户ID
     */
    private String tenantId;

    /**
     * 营运单元
     */
    private Map<String, String> businessUnit;

    /**
     * 由前端确定，是否是开窗，如果是开窗，不走模板
     */
    private Boolean openWindow;

    /**
     * 任务、项目是否为被分享的
     */
    private Boolean isShared;


    /**
     * 活动定义的全局参数
     * 目前用到的币别
     * currency {小数点位数 ：decimal_places ,取数方式：decimal_places_type}
     */
    private Map<String, Object> activityParameter;

    /**
     * 任务or项目不是被分享的
     *
     * @return
     */
    @JsonIgnore
    public boolean isNotShared() {
        return null == isShared || false == isShared;
    }

    /**
     * 任务or项目是被分享的
     *
     * @return
     */
    @JsonGetter("isShared")
    public boolean isShared() {
        return BooleanUtils.isTrue(isShared);
    }

    public static ExecuteContext createByHttpRequest(HttpServletRequest request, String pageCode, String tmProjectId, String tmActivityId, Boolean isShared) {
        String locale = request.getHeader("locale");
        String clientAgent = request.getHeader("client-agent");
        if (StringUtils.isEmpty(clientAgent)) {
            clientAgent = request.getHeader("Client-Agent");
        }
        AuthoredUser authoredUser = (AuthoredUser) request.getAttribute(GlobalConstant.AUTH_USER);
        ExecuteContext executeContext = ExecuteContext.builder()
                .clientAgent(clientAgent)
                .locale(locale)
                .authoredUser(authoredUser)
                .tenantId(authoredUser.getTenantId())
                .pageCode(pageCode)
                .tmActivityId(tmActivityId)
                .tmProjectId(tmProjectId)
                .isShared(isShared)
                .build();
        return executeContext;
    }
}
