package com.digiwin.athena.atmc.http.restful.bpm;

import com.digiwin.athena.atmc.http.restful.bpm.model.BpmTaskApproveActivityDTO;
import com.digiwin.athena.atmc.http.restful.bpm.model.BpmTaskApprovePreviousActivityDTO;
import com.digiwin.athena.atmc.http.restful.bpm.model.BpmTaskApproveRequestDTO;
import com.digiwin.athena.atmc.http.restful.bpm.model.BpmTaskPreApproveRequestDTO;

import java.util.List;
import java.util.Map;

/**
 * BPM任务引擎
 */
public interface TaskEngineService {

    /**
     * 获取预测关卡
     * @param taskUid 任务UID
     * @return
     */
   List<Map> getForeCastTask(String taskUid);

    /**
     * 获取预测关卡 及 预测结束时间
     * @param taskUid
     * @param newPlanEndTime
     * @return
     */
   List<Map> getForeCastTaskAndPlanEndTime(String taskUid, String newPlanEndTime);

    /**
     * 普通人工任务-转派
     * @param workitemId
     * @param oldPerformerId
     * @param newPerformerId
     * @param comment
     */
    void reassignManualTask(String workitemId,String oldPerformerId, String newPerformerId, String comment);

    /**
     * 签核任务-转派
     * @param workitemId
     * @param oldPerformerId
     * @param newPerformerId
     * @param comment
     */
    void reassignApproveTask(String workitemId,String oldPerformerId, String newPerformerId, String comment);

    /**
     * 普通人工任务-派送
     * @param workitemId
     * @param performerId
     * @param comment
     */
    void dispatchTask(String workitemId, String performerId, String comment);

    /**
     * 任务引擎-新增工作事项
     * @param bpmActivityOID
     * @param performerId
     */
    void addWorkitem(String bpmActivityOID, String performerId);

    /**
     * 查询指定任务的签核历程
     * @param requestDTO
     * @return 没有数据返回空集合
     */
    List<BpmTaskApproveActivityDTO> queryApproveByTaskUid(BpmTaskApproveRequestDTO requestDTO);

    /**
     *查询指定任务可退回重签信息
     * @param requestDTO
     * @return
     */
    BpmTaskApprovePreviousActivityDTO queryPreApprove(BpmTaskPreApproveRequestDTO requestDTO);

    /**
     * 批次关闭任务
     */
    void batchTerminateTask(List<String> taskUids);

   /**
    * 项目转派时，批量变更当责者，<br>
    * 只支持任务引擎
    * @param personInCharge
    * @param personInChargeName
    * @param processSerialNumberList
    */
   void batchChangePersonInCharge(String personInCharge, String personInChargeName, List<String> processSerialNumberList);
}
