package com.digiwin.athena.atmc.http.restful.iam.impl;

import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.constant.IamApiConstant;
//import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.iam.LoginService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@Service
public class LoginServiceImpl implements LoginService {

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Override
    public String login(String userId, String password) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        Map<String, String> param = new HashMap<>();
        param.put("userId", userId);
        param.put("password", password);
        param.put("identityType", "token");
        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);

        String url = envProperties.getIamUri() + IamApiConstant.IDENTITY_LOGIN;
        ResponseEntity<Map> responseEntity = restTemplate.postForEntity(url, httpEntity, Map.class);
        Map body = responseEntity.getBody();
        if (body == null) {
            return null;
        } else {
            return body.get("token").toString();
        }
    }
}
