package com.digiwin.athena.atmc.http.restful.aim;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.http.domain.message.AimEventDO;
import com.digiwin.athena.atmc.http.domain.message.MessageBatchUserDTO;
import com.digiwin.athena.atmc.http.domain.message.MessageDO;
import com.digiwin.athena.atmc.http.restful.aim.model.OnlineClient;
import com.digiwin.athena.atmc.http.restful.emc.model.AppMessageDTO;
import org.springframework.http.ResponseEntity;

import java.util.List;
import java.util.Map;

/**
 * 对接Aim服务
 *
 * @author majfa
 * @since [迭代13]
 */
public interface AimService {

    /**
     * 批量保存新消息
     *
     * @param authoredUser
     * @param messageList
     */
    void saveNewMessage(AuthoredUser authoredUser, List<MessageBatchUserDTO> messageList);

    /**
     * 根据租户删除数据
     *
     * @Author：SYQ
     * @Date：2022/1/12 10:18
     */
    Map<String, Integer> deleteByTenant(AuthoredUser authoredUser, String tenantId);

    /**
     * 发送催办事件通知
     */
    void sendUrageDealNotice(AuthoredUser user, AimEventDO event);

    void message(AuthoredUser authoredUser, MessageDO message);

    /**
     * 根据制定用户来获取
     *
     * @param tenantId 租户id
     * @param userId   用户id
     * @return 在线用户
     */
    List<OnlineClient> queryByUserId(String tenantId, String userId);

    /**
     * 发送消息给在线客户端
     */
    void sendMessageToClient(String token, String tenantId, List<String> userIdList, MessageDO message);

    /**
     * 发送消息提醒
     *
     * @Author：SYQ
     * @Date：2022/4/11 15:08
     */
    void sendMsgRemindToClient(String token, String tenantId, String userId, AppMessageDTO appMessageDTO);
    /**
     * 发送消息提醒
     *
     * @Author：SYQ
     * @Date：2022/4/11 15:08
     */
    void batchSendMessageRemindToClient(String token, String tenantId, List<AppMessageDTO> appMessageList);

    /**
     * 重置消息数据
     */
    ResponseEntity<Map> resetAIMData();

}
