package com.digiwin.athena.atmc.http.restful.bpm.impl;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.constant.WorkflowConstant;
import com.digiwin.athena.atmc.http.restful.bpm.WorkflowService;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

@Service
public class WorkflowServiceImpl implements WorkflowService {

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Override
    public Map<String, Object> getWorkflowProcess(String serialNumber, String workItemId) {
        Map<String,Object> paramMap = Maps.newHashMapWithExpectedSize(2);
        paramMap.put("serialNumber",serialNumber);
        paramMap.put("workItemId",workItemId);
        //头部信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //获取appId接口地址
        String getAppIdUrl = envProperties.getWorkflowUri() + WorkflowConstant.WORKFLOW_HISTORY_URL;
        //查询数据
        HttpEntity<?> httpEntity = new HttpEntity<>(paramMap, headers);
        ResponseEntity<BaseResultDTO<Map<String,Object>>> responseEntity = restTemplate.exchange(getAppIdUrl, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<Map<String,Object>>>(){});
        BaseResultDTO<Map<String, Object>> body = responseEntity.getBody();
        if(body != null){
            return body.getResponse();
        }
        return null;
    }
}
