package com.digiwin.athena.atmc.http.restful.xiaohui.impl;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.constant.XiaohuiApiConstant;
//import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.xiaohui.SendMessageXhService;
import com.digiwin.athena.atmc.http.restful.xiaohui.model.MessageDTO;
import com.digiwin.athena.atmc.http.restful.xiaohui.model.MessageUrlDTO;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

/**
 * @description:
 * @author: xusj
 * @date: 2023/1/31 14:10
 */
@Slf4j
@Service
public class SendMessageXhServiceImpl implements SendMessageXhService {


    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public void send(MessageDTO messageDTO) {
        String url = envProperties.getXiaohuiUri() + XiaohuiApiConstant.PUSH_HDATA;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<?> httpEntity = new HttpEntity<>(messageDTO, headers);
        log.info("[SendMessageServiceImpl] SetPushHData message is : {}",messageDTO);
        restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class);
    }

    @Override
    public void send(JSONObject messageDTO) {
        String url = envProperties.getXiaohuiUri() + XiaohuiApiConstant.PUSH_HDATA;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<?> httpEntity = new HttpEntity<>(messageDTO, headers);
        restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class);
        return;
    }

    @Override
    public void sendUrl(MessageUrlDTO messageDTO) {
        try {
            String url = envProperties.getXiaohuiUri() + XiaohuiApiConstant.PUSH_HDATA_URL;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity<?> httpEntity = new HttpEntity<>(messageDTO, headers);
            log.info("[SendMessageServiceImpl] SetPushHDataURL message is : {}", JsonUtils.objectToString(messageDTO));
            restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class);
        } catch (Exception e) {
            log.error("[SendMessageServiceImpl] SetPushHDataURL message is : {}, error message: {}", JsonUtils.objectToString(messageDTO), e.getMessage());
        }

    }
}
