package com.digiwin.athena.atmc.http.restful.dap.impl;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.constant.DapApiConstant;
import com.digiwin.athena.atmc.http.restful.dap.DapService;

import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class DapServiceImpl implements DapService {
    private static final Logger logger = LoggerFactory.getLogger(DapServiceImpl.class);

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    /**
     * 调用DAP接口创建伙伴关系
     * @Author：SYQ
     * @Date：2021/5/19 11:25
     */
    public boolean createAuthorization(String customTenantId,String appId,String token){
        boolean result = false;
        //获取用户信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        /*判断是否已经建立了伙伴关系 start*/
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("partnerTenantid",customTenantId);
        HttpEntity<?> validHttpEntity = new HttpEntity<>(headers);
        String validUrl = envProperties.getTdscUri() + DapApiConstant.TDSC_PARTNER_RELATIONSHIP_VALID_PARTNER_TENANTID_PARTNER_TENANTID;
        ResponseEntity<Map> validResponse = restTemplate.exchange(validUrl, HttpMethod.GET, validHttpEntity, Map.class, paramMap);
        if(validResponse.getStatusCode() == HttpStatus.OK){
            Object response = validResponse.getBody().get("response");
            if(response != null && response != ""){
                Map<String,String> dataMap = JsonUtils.jsonToObject(JsonUtils.objectToString(response),Map.class);
                String data = dataMap.get("data");
                if("true".equalsIgnoreCase(data)){
                    return true;
                }
            }
        }
        /*判断是否已经建立了伙伴关系 end*/


        //租户id
        List<String> tenantIdList = new ArrayList<>();
        tenantIdList.add(customTenantId);

        //授权内容
        List<Map> authorizationsList = new ArrayList<>();
        Map<String,Object> authorizationsMap = new HashedMap();
        authorizationsMap.put("dataProviderAppId",appId);
        authorizationsMap.put("dataProviderResourceName","/api/atmc/v1/activity/changed");
        authorizationsMap.put("authDateStart", LocalDate.now());
        authorizationsMap.put("authDateEnd", "9999-12-31");
        authorizationsList.add(authorizationsMap);

        //请求参数
        paramMap.clear();
        paramMap.put("partnerTenantids",tenantIdList);
        paramMap.put("authGroup","multiTenant");
        paramMap.put("authorizations",authorizationsList);
        HttpEntity<?> httpEntity = new HttpEntity<>(paramMap,headers);
        //创建伙伴关系接口地址
        String url = envProperties.getTdscUri() + DapApiConstant.TDSC_AUTHORIZATION_VALID;
        //调用接口
        ResponseEntity<Map> responseEntity = restTemplate.postForEntity(url,httpEntity, Map.class);
        responseEntity.getStatusCode();
        if(responseEntity.getStatusCode() == HttpStatus.OK){
            result = true;
        }
        return result;
    }
}
