package com.digiwin.athena.atmc.http.restful.thememap.model;

import lombok.Data;

import java.util.List;

/**
 * 对API的参数过滤
 */
@Data
public class TmDataFilter {


    /**
     * Filter 编码
     */
    private String code;
    /**
     * 默认优先使用
     */
    private Boolean defaultFilter;


    /**
     * 显示名称
     */
    private String title;

    /**
     * 查询任务的类型
     */
    private String queryTaskType;

    /**
     * 过滤器类型
     */
    private String type;


    /**
     * 为true时，表示使用API进行过滤，服务端过滤，使用conditions，
     * 为false时，表示客户端过滤，使用scriptCondition
     */
    private boolean apiFilter;

    /**
     * 过滤器描述（需要外显）
     */
    private String description;


    /**
     * 作用范围（项目,任务 --卡片，详情）
     */
    private String applyTo;

    /**
     * 作用于数据源
     */
    private List<String> dataSourceNames;



    /**
     * 显示前limit条数据
     */
    private Integer limit;

    /**
     * 显示获总条数类型
     */
    private String rowSizeType;
}
