/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.aam.impl;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.domain.misc.DemoItemResultDTO;
import com.digiwin.athena.atmc.http.restful.aam.AamService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AamServiceImpl
implements AamService {
    private static final Logger log = LoggerFactory.getLogger(AamServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    MessageUtils messageUtils;

    @Override
    public DemoItemResultDTO resetAAMData() {
        DemoItemResultDTO result = new DemoItemResultDTO();
        result.setSuccess(true);
        result.setItem("AAM \u6e05\u9664\u6570\u636e");
        result.setStartTime(LocalDateTime.now());
        result.setMessage(new ArrayList<String>());
        List<String> msgList = result.getMessage();
        try {
            String uri = this.envProperties.getAamUri() + "/api/aam/v1/misc/demo/reset";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            ResponseEntity r = this.restTemplate.getForEntity(uri, Map.class, new Object[0]);
            if (!((Map)r.getBody()).containsKey("status") || !Objects.equals(((Map)r.getBody()).get("status"), 200)) {
                msgList.add("AAM \u6e05\u9664\u6570\u636e \u51fa\u73b0\u5f02\u5e38\uff0c\u8be6\u60c5\u67e5\u770b\u65e5\u5fd7");
                result.setSuccess(false);
                log.error("[AAM \u6e05\u9664\u6570\u636e]", r.getBody());
            }
        }
        catch (Exception ex) {
            result.setSuccess(false);
            msgList.add("AAM \u6e05\u9664\u6570\u636e \u51fa\u73b0\u5f02\u5e38\uff0c\u8be6\u60c5\u67e5\u770b\u65e5\u5fd7");
            msgList.add(ex.getMessage());
            log.error("[AAM \u6e05\u9664\u6570\u636e]", (Throwable)ex);
        }
        result.setEndTime(LocalDateTime.now());
        return result;
    }
}

