package com.digiwin.athena.atmc.http.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.atmc.core.meta.enums.ActivityStateEnum;
import com.digiwin.athena.atmc.http.handler.MySqlJsonHandler;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.sf.json.JSONObject;

import java.time.LocalDateTime;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true)
public class Activity extends BaseEntity<Activity> {
    @TableId()
    private Long id;

    private String name;

    private Long bpmProcessId;

    private Long taskId;

    private Long activityDefineId;

    /**
     * 计划开始时间
     */
    private LocalDateTime startTime;

    /**
     * 计划结束时间
     */
    private LocalDateTime endTime;

    private LocalDateTime actualStartTime;

    private LocalDateTime actualEndTime;

    private Boolean exception;

    private Integer state;


    private ActivityStateEnum activityStateEnum;

    /**
     * bpm推送的关卡数据
     */
    @TableField(typeHandler = MySqlJsonHandler.class)
    private JSONObject data;
}