package com.digiwin.athena.atmc.http.restful.im;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.http.restful.im.model.IMSendMessageDTO;
import com.digiwin.athena.atmc.http.restful.im.model.ImNeteaseUserDTO;
import com.digiwin.athena.atmc.http.restful.im.model.TeamMemberInfoDTO;

import java.util.List;
import java.util.Map;

/**
 * ImService Description
 *
 * @author majianfu
 * @date 2021/7/10
 * @since
 */
public interface ImService {
    /**
     * 根据群id获取群成员信息
     *
     * @param tid
     * @return
     */
    List<TeamMemberInfoDTO> queryTeamMembers(Long tid);

    /**
     * 推送消息
     *
     * @param token
     * @param messageDTO
     */
    void pushMessage(String token, IMSendMessageDTO messageDTO);

    /**
     * 批量根据userId获取IM 网易云信账号
     * @param userIdList
     * @return
     */
    List<ImNeteaseUserDTO> queryNeteaseUsers(List<String> userIdList);

    /**
     * 关闭群（用于atmc）
     * @Author：SYQ
     * @Date：2021/6/16 11:13
     */
    void removeTeam(String bizId, int type, AuthoredUser user);

    /**
     * 修改群信息
     * @Author：SYQ
     * @Date：2021/10/25 15:28
     */
    void updateTeamInfo(AuthoredUser user,String tid,String cardIds);

    /**
     * 添加群成员
     * @Author：SYQ
     * @Date：2021/6/10 17:20
     */
    void addTeamMembers(AuthoredUser user,String bizId,int type,List<String> memberList);

    /**
     * 创建群
     * @Author：SYQ
     * @Date：2021/6/10 17:14
     */
    void createTeam(AuthoredUser user, String owner, String teamName, String bizId, int type,
                           int ifMaster, int visiable, List<String> memberList, String pId,
                           List<Map> externalAccounts, List<Map> externalEocMembers, String businessKey);

    /**
     * 获取群信息
     * @Author：SYQ
     * @Date：2021/10/25 15:28
     */
    Map getTeamInfo(AuthoredUser user,String bizId,int type,String source);

    /**
     * 根据租户清除数据
     * @Author：SYQ
     * @Date：2022/1/10 16:22
     */
    Map<String,Integer> clearDataByTenantSid(AuthoredUser user);

    /**
     * 批量解散群(用于pcc)
     * @Author：SYQ
     * @Date：2021/11/1 17:54
     */
    void removeTeamByParam(String bizId,int type,String cardId,String businessKey,AuthoredUser user);
}
