package com.digiwin.athena.atmc.http.constant;

/**
 * @Author wuzq
 * @Date 2023/6/7 16:00
 * @Description: aim API
 * @Version 1.0
 */
public class AimApiConstant {
    private AimApiConstant() {
    }

    /**
     * 存储新消息
     */
    public static final String MESSAGE = "/api/aim/v1/message";

    /**
     * 批量保存新消息
     */
    public static final String BATCH_USER_MESSAGE = "/api/aim/v2/batch/user/message";

    /**
     * 根据租户删除数据
     */
    public static final String MISC_MESSAGE_DELETE_BY_TENANT = "/api/aim/v1/misc/message/deleteByTenant/{tenantId}";

    /**
     * 发送催办事件通知
     */
    public static final String EVENT_MQ_SEND_URGE_DEAL_EVENT = "/api/aim/v1/event/mq/send/urge/deal/event";

    /**
     * 根据制定用户来获取
     */
    public static final String CLIENTS_TENANTID_USERID = "/clients/{tenantId}/{userId}";

    /**
     * 发送消息给在线客户端
     */
    public static final String SEND_MESSAGE_TO_CLIENT = "/api/aim/v2/send/message/to/client";

    /**
     * 发送消息提醒
     */
    public static final String SEND_MESSAGE_REMIND_TO_CLIENT = "/api/aim/v2/send/message/remind/to/client";

    /**
     * 批量发送消息提醒
     */
    public static final String BATCH_SEND_MESSAGE_REMIND_TO_CLIENT = "/api/aim/v2/batch/send/message/remind/to/client";

    /**
     * 重置消息数据
     */
    public static final String MISC_DEMO_RESET = "/api/aim/v1/misc/demo/reset";

}
