package com.digiwin.athena.atmc.http.constant;

/**
 * @Author wuzq
 * @Date 2023/6/8 9:47
 * @Description: uibot API
 * @Version 1.0
 */
public class UibotApiConstant {
    private UibotApiConstant() {
    }

    /**
     * 获取项目卡CheckItems等数
     */
    public static final String PROJECT_CARD_TM_TASK_ID_TM_ACTIVITY_ID_PROJECT_ID = "api/ai/v1/bot/project/card/{tmTaskId}/{tmActivityId}/{projectId}";

    /**
     * 获取项目卡CheckItems等数,根据据项目自身的数据，不依赖任务
     */
    public static final String PROJECT_CARD_TM_TASK_ID_TM_TASK_ID = "api/ai/v1/bot/project/card/{tmTaskId}/{projectId}";

    /**
     * 获取任务卡CheckItems等数
     */
    public static final String TASK_TM_TASK_ID_TM_ACTIVITY_ID_DATA_SIZE = "api/ai/v1/bot/task/{tmTaskId}/{tmActivityId}/data/size";

    /**
     * 获取项目的数据大小
     */
    public static final String PROJECT_TM_TASK_ID_TM_ACTIVITY_ID_DATA_SIZE = "api/ai/v1/bot/project/{tmTaskId}/{tmActivityId}/data/size";

    /**
     * 获取任务卡CheckItems等数
     */
    public static final String TASK_CARD_TM_TASK_ID_TM_ACTIVITY_ID_BACKLOG_ID = "api/ai/v1/bot/task/card/{tmTaskId}/{tmActivityId}/{backlogId}";

    /**
     * 获取任务卡 拼接字符等数
     */
    public static final String TASK_CARD_ABSTRACT_TM_TASK_ID_TM_ACTIVITY_ID_BACKLOG_ID = "api/ai/v1/bot/task/card/abstract/{tmTaskId}/{tmActivityId}/{backlogId}";


    /**
     * 获取任务卡标题
     */
    public static final String TASK_TITLE_TM_TASK_ID_TM_ACTIVITY_ID= "api/ai/v1/bot/task/getCardTitle/{tmTaskId}/{tmActivityId}";

    /**
     * 获取卡片标题,传入tmActivityId代办任务卡，不传项目卡
     */
    public static final String CARD_TITLE_URL= "api/ai/v1/bot/task/getCardTitle/{tmTaskId}";


    /**
     * 获取卡面数据
     */
    public static final String CARD_BUSINESS_MESSAGE = "api/ai/v1/bot/card/businessMessage/{tmTaskId}/{tmActivityId}";

    /**
     * 获取卡面数据
     */
    public static final String CARD_BUSINESS_MESSAGE2 = "api/ai/v1/bot/card/businessMessage/{tmTaskId}";

    /**
     *  获取批量卡面数据
     */
    public static final String CARD_BATCH_BUSINESS_URL = "api/ai/v1/bot/card/businessBatchMessage";

    /**
     * 获取任务卡 最新的摘要信息（用所有页签的数据）
     */
    public static final String TASK_CARD_ABSTRACT_PAGE_DATA = "api/ai/v1/bot/task/card/abstract/up/to/date/{tmTaskId}/{tmActivityId}/{backlogId}";

    /**
     * 项目卡摘要信息，不依赖任务（字符串）
     */
    public static final String PROJECT_CARD_ABSTRACT_TM_TASK_ID_PROJECT_ID = "api/ai/v1/bot/project/card/abstract/{tmTaskId}/{projectId}";

    /**
     * 项目卡-任务摘要信息（字符串）
     */
    public static final String PROJECT_CARD_ABSTRACT_TM_TASK_ID_TM_ACTIVITY_ID_PROJECT_ID = "api/ai/v1/bot/project/card/abstract/{tmTaskId}/{tmActivityId}/{projectId}";

    /**
     * 获取任务卡CheckItems等数
     */
    public static final String DATA_QUERY_BY_ACTIVITY = "api/ai/v1/data/query/by/activity";

    /**
     * 查询报表信息
     */
    public static final String REPORT_QUERY_EXCEL_INFO = "api/v1/ai/report/queryExcelInfo";

    /**
     *
     */
    public static final String DATA_QUERY_ACTION = "api/ai/v1/data/query/action";

    /**
     * 获取报表页面数据
     */
    public static final String TEMPLATE_STATEMENT_CONDITION_SHOW_REPORT_CODE = "api/ai/v1/bot/template/statement/condition/show/{reportCode}";

    /**
     * 获取任务详情页面pageData
     */
    public static final String TASK_PAGE_DATA_TM_TASK_ID_TM_ACTIVITY_ID_WORK_ITEM_ID = "/api/ai/v1/bot/task/page-data/{tmTaskId}/{tmActivityId}/{workItemId}";

    /**
     * 获取任务详情页面的submitActions
     */
    public static final String TASK_SUBMITACTIONS_TM_TASK_ID_TM_ACTIVITY_ID = "/api/ai/v1/bot/task/submitactions/{tmTaskId}/{tmActivityId}";

    /**
     * 获取 项目 转派的执行action
     */
    public static final String ACTION_PROJECT_REASSIGN = "api/ai/v1/bot/action/project/reassign";

    /**
     * 获取 任务 转派的执行action
     */
    public static final String ACTION_TASK_REASSIGN = "api/ai/v1/bot/action/task/reassign";

    /**
     * 清除缓存
     */
    public static final String CACHE_RESET = "api/cache/reset?size={size}";

    /**
     * 根据状态查询任务数据接口
     */
    public static final String QUERY_TASK_DATA_BY_STATE_TM_ACTIVITY_ID_BACKLOG_ID_DATA_STATE_CODE = "/api/ai/v1/data/query/task/dataByState/{tmTaskId}/{tmActivityId}/{backlogId}/{dataStateCode}";

    /**
     * 获取详情页面的submitActions
     */
    public static final String GET_SUBMIT_ACTIONS = "api/ai/v1/bot/submitactions/{tmTaskId}/{tmActivityId}/{pageCode}";

    public static final String TASK_CARD_ABSTRACT_TM_TASK_ID_TM_ACTIVITY_ID = "api/ai/v1/bot/task/card/abstract/batch/{tmTaskId}/{tmActivityId}/{bkContact}";
}
