package com.digiwin.athena.atmc.http.domain;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

@Data
@Validated
@AllArgsConstructor
@NoArgsConstructor
public class TaskCardFieldRequest implements Serializable {

    /**
     * 指定查询TaskCardField下的字段
     */
    private String queryField;

    /**
     * 项目或任务的code
     */
    @NotEmpty
    private List<String> code;

    @NotBlank
    private String pageCode;
}
