package com.digiwin.athena.atmc.http.domain.backlog;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 * 终止数据
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class TerminateTaskDataDTO {

    /**
     * 数据足迹的actId，ptm的task表的id
     */
    private Long taskId;

    /**
     * 要终止的数据，数组，支持多个数据
     */
    private List<Map<String,Object>> data;

    /**
     * data的字段名称，用于比较找到要清除的数据
     */
    private List<String> uniKeys;

    /**
     * 表示要清除bpmData中哪个字段的数据
     */
    private String dataVariableKey;
}
