package com.digiwin.athena.atmc.http.domain.message;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

@Data
@NoArgsConstructor
public class MessageDO {
    private String gid;

    private String userId;

    private String userName;

    private String langName;

    private String tenantId;

    /**
     * 消息类型，如：项目：TASK；任务：ACTIVITY
     */
    private String type;

    /**
     * 消息子类型，如：交期回复异常排除：checkConfirmDeliveryDateSolveProblem
     */
    private String subType;

    /**
     * 消息子类型所属类别，如：项目异常/逾期提醒
     */
    private String subTypeCategory;

    /**
     * 消息类别，多个消息类别以英文逗号隔开，如：NEW,EMERGENCY
     */
    private String category;

    /**
     * 重要性，0：不重要，1：重要
     */
    private Integer importance;

    private String source;

    /**
     * 消息状态，消息状态，0：未读，1：已读，3：过期，4：关闭
     */
    private Integer state;

    private String title;

    private Object content;

    private String jsonContent;
    /**
     * 消息发送时间
     */
    private LocalDateTime sendDate;

    /**
     * 消息生效时间
     */
    private LocalDateTime startTime;

    /**
     * 消息过期时间
     */
    private LocalDateTime endTime;

    private LocalDateTime createDate;

    private LocalDateTime modifyDate;

    /**
     * 是否需要通知到移动端APP
     */
    private Boolean noticeMobileApp;

    /**
     * 应用授权信息
     */
    private String appCode;

    private String appName;

    private Boolean hasAppPermission;

    /**
     * 文件id
     */
    private String fileId;

    /**
     * 文档中心的bucket
     */
    private String dmcBucket;
}
