package com.digiwin.athena.atmc.http.domain.task;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 异常任务信息
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class TaskExceptionDTO {

    /**
     * 里程碑名称
     */
    private String phaseName;

    /**
     * 里程碑下异常任务集合
     */
    private List<TaskExceptionData> tasks;


    @Data
    public static class TaskExceptionData {
        /**
         * 任务名称
         */
        private String taskName;

        /**
         * 异常信息
         */
        private String exception;

        /**
         * 异常时间
         */
        private String exceptionDate;

        /**
         * 所属任务id
         */
        private long taskId;
    }


}
