package com.digiwin.athena.atmc.http.restful.adsc;

import com.digiwin.athena.atmc.http.domain.action.SubmitActionDTO;
import com.digiwin.athena.atmc.http.restful.adsc.model.SubmitDataCheckResDto;

/**
 * adsc服务：用于任务提交前的数据校验和adsc层数据同步
 * @author：jianglpc
 * @date：2023/3/8
 */
public interface AdscService {

    /**
     * 提交数据，并且当时全选提交时提供默认值校验
     *
     * @param submitActionDTO
     * @return
     */
    SubmitDataCheckResDto submitDataWithCheck(SubmitActionDTO submitActionDTO);

    /**
     * 删除adsc缓存
     *
     * @param submitActionDTO
     * @return
     */
    void removeData(SubmitActionDTO submitActionDTO);
}
