package com.digiwin.athena.atmc.http.restful.adsc.model;

import com.google.common.collect.Maps;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * adsc校验提交dto
 *
 * @author：jianglpc
 * @date：2023/3/8
 */
@Data
@NoArgsConstructor
public class SubmitDataCheckResDto implements Serializable {

    /**
     * 是否存在错误，只要为true，就代表有校验不通过
     */
    private boolean existWrong;

    /**
     * 结果明细
     */
    private List<SubmitDataCheckSIngleResDto> resultDetail;

    /**
     * 创建一个map
     * @return
     */
    public Map<String, Object> converToMap() {
        Map<String,Object> map = Maps.newHashMap();
        map.put("existWrong", existWrong);
        map.put("resultDetail", resultDetail);
        return map;
    }

    /**
     * 提交数据
     */
    private Map<String,Object> initData;
}
