package com.digiwin.athena.atmc.http.restful.aglie;


import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.atmc.http.domain.ExecuteContext;
import com.digiwin.athena.atmc.http.domain.action.SubmitAction;
import com.digiwin.athena.atmc.http.domain.report.ExcelParamsDTO;
//import com.digiwin.athena.atmc.http.domain.task.ActivityDataDTO;
import com.digiwin.athena.atmc.http.restful.aglie.model.AglieDynamicFormDTO;
import com.digiwin.athena.atmc.http.restful.aglie.model.CardDataParam;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.ActivityDataBO;
import net.sf.json.JSONObject;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface AglieService {

    /**
     * 获取项目卡CheckItems等数
     *
     * @param tmTaskId
     * @param tmActivityId
     * @param projectId
     * @return
     */
    BaseResultDTO<Map<String, Object>> getProjectCardData(String tmTaskId, String tmActivityId, Long projectId, Object activityDataDTO);

    /**
     * 获取项目卡CheckItems等数,根据据项目自身的数据，不依赖任务
     *
     * @param tmTaskId
     * @param projectId
     * @return
     */
    BaseResultDTO<Map<String, Object>> getProjectCardDataByProjectData(String tmTaskId, Long projectId, Object activityDataDTO);

    /**
     * 获取任务的数据大小
     *
     * @param tmTaskId
     * @param tmActivityId
     * @param activityDataDTO
     * @return
     */
    BaseResultDTO<HashMap> getTaskCardDataSize(String tmTaskId, String tmActivityId, Object activityDataDTO);

    /**
     * 获取项目的数据大小
     *
     * @param tmTaskId
     * @param tmActivityId
     * @param activityDataDTO
     * @return
     */
    BaseResultDTO<HashMap> getProjectCardDataSize(String tmTaskId, String tmActivityId, Object activityDataDTO);

    /**
     * 获取任务卡CheckItems等数
     *
     * @param tmTaskId
     * @param tmActivityId
     * @param backlogId
     * @return
     */
    BaseResultDTO<AglieDynamicFormDTO> getTaskCardLayout(String tmTaskId, String tmActivityId, Long backlogId,
                                                         Object activityDataDTO, String flag);

    /**
     * 获取任务卡CheckItems等数
     *
     * @return
     */
    BaseResultDTO<JSONObject> getData(ActivityDataBO activityDataBO);

    BaseResultDTO<JSONObject> queryData(String token, Object activityDataDTO);

    /**
     * 查询报表信息
     * @param excelParamsDTO
     * @return
     */
    List<Map<String,Object>> queryExcelInfo(ExcelParamsDTO excelParamsDTO);

    BaseResultDTO<JSONObject> analysisQueryAction(ExecuteContext executeContext, Map tmAction);

    /**
     * 获取报表页面数据
     *
     * @param reportCode
     * @return
     */
    Map getReportTemplatePage(String reportCode);

    /**
     * 获取任务详情页面pageData
     *
     * @param tmTaskId
     * @param tmActivityId
     * @param workItemId
     * @return
     */
    Map getTaskPageData(String tmTaskId, String tmActivityId, Long workItemId);

    /**
     * 获取任务详情页面的submitActions
     *
     * @param tmTaskId
     * @param tmActivityId
     * @return
     */
    List<Map> getTaskPageSubmitActions(String tmTaskId, String tmActivityId,  Map<String, Object>  activityData);

    /**
     * 获取任务卡 拼接字符等数
     *
     * @param tmTaskId
     * @param tmActivityId
     * @param backlogId
     * @return
     */
    BaseResultDTO<Map> getTaskCardAbstractStr(String tmTaskId, String tmActivityId, Long backlogId, Object activityDataDTO,Integer count,String langName);

    /**
     * 获取卡面业务数据
     *
     * @param tmTaskId
     * @param tmActivityId
     * @param activityDataDTO
     * @return
     */
    BaseResultDTO<Map<String,Object>> getCardBusinessMessage(String tmTaskId, String tmActivityId, Object activityDataDTO);


    /**
     * 获取卡面业务数据
     *
     * @param tmTaskId
     * @param tmActivityId
     * @param cardDataParam
     * @return
     */
    BaseResultDTO<Map<String,Map<Long, Map<Long,Map<String, Object>>>>> getBatchCardBusinessMessage(String tmTaskId, String tmActivityId, CardDataParam cardDataParam);

    /**
     * 获取任务卡标题
     *
     * @param tmTaskId
     * @param tmActivityId
     * @param activityDataDTO
     * @return
     */
    BaseResultDTO<Map<String,Object>> getTaskCardTitle(String tmTaskId, String tmActivityId, Object activityDataDTO);



    /**
     * 获取项目卡CheckItems等数,根据据项目自身的数据，不依赖任务（字符串）
     *
     * @param tmTaskId
     * @param projectId
     * @return
     */
    BaseResultDTO<Map<String, Object>> getProjectCardDataByProjectDataAbstract(String tmTaskId, Long projectId, Object activityDataDTO);

    /**
     * 获取项目卡CheckItems等数（字符串）
     *
     * @param tmTaskId
     * @param tmActivityId
     * @param projectId
     * @return
     */
    BaseResultDTO<Map<String, Object>> getProjectCardDataAbstract(String tmTaskId, String tmActivityId, Long projectId,
                                                                  Object activityDataDTO);


    /**
     * 获取任务卡CheckItems等数
     *
     * @param tmTaskId
     * @param tmActivityId
     * @param backlogId
     * @return
     */
    BaseResultDTO<Map> getTaskCardLayoutAbstract(String tmTaskId, String tmActivityId, Long backlogId,
                                                         Object activityDataDTO, String flag,Integer count,String langName);

    /**
     * 获取任务卡最新参数
     *
     * @param tmTaskId
     * @param tmActivityId
     * @param backlogId
     * @return
     */
    BaseResultDTO<Map> getTaskCardLayoutAbstractUpToDate(String tmTaskId, String tmActivityId, Long backlogId,
                                                 Object activityDataDTO, String flag);
    /**
     * 获取 项目 转派的执行action
     *
     * @param queryAction
     * @return
     */
    List<SubmitAction> generateProjectReassignAction(Map queryAction);

    /**
     * 获取 任务 转派的执行action
     *
     * @param queryAction
     * @return
     */
    List<SubmitAction> generateTaskReassignAction(Map queryAction);

    /**
     * 清除缓存
     */
    void clearCache(Long size);

    /**
     * 获取任务数据
     * @param tmTaskId
     * @param tmActivityId
     * @param backlogId
     * @param dataStateCode
     * @return
     */
    Map<String, Object> getTmtask(String tmTaskId, String tmActivityId, String backlogId,
                                                                  String dataStateCode, String token);

    /**
     * 获取详情页提交信息
     * @param tmTaskId
     * @param tmActivityId
     * @param activityData
     * @param pageCode
     * @return
     */
    List<Map> getProjectPageSubmitActions(String tmTaskId, String tmActivityId, Map<String, Object> activityData, String pageCode);


    BaseResultDTO<Map> getTaskCardAbstractStrBatch(String tmTaskId, String tmActivityId, String bks, Object activityDataDTO);

}

