package com.digiwin.athena.atmc.http.restful.aglie.model;

import lombok.Data;
import org.apache.commons.collections.MapUtils;

import java.util.List;
import java.util.Map;

@Data
public class AglieDynamicFormDTO {

    /**
     * 样式，相当于CSS
     */
    private Map style;

    /**
     * 前端UI组件模型，
     * ViewModel,相当于HTML。
     */
    private List layout;

    /**
     * UI画面的动作集合，理论上有几个Action，就显示几个按钮供用户操作。
     */
    private Boolean  finished;
    private String finishedTitle;

    /**
     * 页面数据
     */
    private Map<String,Object> pageData;

    private Map<String,Object> content;

    /**
     * 汇总数据显示
     */
    private Integer pageCountSize;

    public boolean isDefaultFilter(){
        if (MapUtils.isNotEmpty(this.content) && this.content.containsKey("filterDefault")){
            return (Boolean)this.content.get("filterDefault");
        }
        return false;
    }

    public String getTitle(){
        if (MapUtils.isNotEmpty(this.content) && this.content.containsKey("filterTitle")){
            return (String)this.content.get("filterTitle");
        }
        return null;
    }

    public int getPageDataSize(){

        if(pageCountSize!=null && pageCountSize>0){
            return pageCountSize;
        }

        return 0;
    }
}
