package com.digiwin.athena.atmc.http.restful.asa.impl;

import cn.hutool.json.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.core.meta.constants.GlobalConstant;
import com.digiwin.athena.atmc.http.constant.AsaApiConstant;
import com.digiwin.athena.atmc.http.restful.asa.AsaRService;
import com.digiwin.athena.atmc.http.restful.asa.model.AsaBacklogDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

/**
 * @Description
 * @Author cai chao
 * @Date 2024/4/16 19:49
 */
@Slf4j
@Service
public class AsaRServiceImpl implements AsaRService {
    @Autowired
    RestTemplate restTemplate;

    @Autowired
    private EnvProperties envProperties;

    @Override
    public void ptmMqMessageReceiveAsa(AsaBacklogDTO asaBacklogDTO) {
        //请求地址
        String url = envProperties.getAsaUri() + AsaApiConstant.COLLECT_CAPACITY_CREATE;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //获取列表时，传当前token，如果使用代理token，获取的就是代理token的列表
        headers.add(GlobalConstant.IAM_USER_TOKEN, AppAuthContextHolder.getContext().getAuthoredUser().getToken());

        HttpEntity<AsaBacklogDTO> httpEntity = new HttpEntity<>(asaBacklogDTO, headers);
        log.info("AsaRServiceImpl.ptmMqMessageReceiveAsa.asaBacklogDTO:{}", asaBacklogDTO);
        ResponseEntity<JSONObject> response = restTemplate.postForEntity(url, httpEntity, JSONObject.class);
        log.info("AsaRServiceImpl.ptmMqMessageReceiveAsa.result:{}", response);

    }
}
