package com.digiwin.athena.atmc.http.restful.cam.impl;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.constant.CamApiConstant;
import com.digiwin.athena.atmc.core.meta.constants.GlobalConstant;
import com.digiwin.athena.atmc.http.restful.cac.model.BaseCacResult;
import com.digiwin.athena.atmc.http.restful.cam.CamService;
import com.digiwin.athena.atmc.http.restful.cam.model.AppMappingsDTO;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


@Slf4j
@Service
public class CamServiceImpl implements CamService {


    @Autowired
    private EnvProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;


    @Override
    public Map<String, String> getAppMappings(String userToken, String appCode) {
        Map<String, String> appMappingMap =  Maps.newHashMap();
        if (StringUtils.isEmpty(appCode)) {
            return appMappingMap;
        }
        String url = envProperties.getCamUri() + CamApiConstant.APP_MAPPINGS_CAM;
        url = String.format(url, appCode);
        HttpHeaders headers = new HttpHeaders();
        headers.set(GlobalConstant.IAM_USER_TOKEN, userToken);
        headers.set(GlobalConstant.IAM_APP_TOKEN, com.digiwin.athena.appcore.auth.GlobalConstant.IAM_APP_TOKEN_ATHENA);
        HttpEntity<JSONObject> httpEntity = new HttpEntity<>(headers);
        try {
            log.info("请求CAM获取应用信息 入参:{}", JsonUtils.objectToString(httpEntity));
            ResponseEntity<BaseCacResult<List<AppMappingsDTO>>> respEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseCacResult<List<AppMappingsDTO>>>() {
                    });
            if (respEntity.getStatusCode().value() != org.apache.http.HttpStatus.SC_OK) {
                log.info("请求CAM获取应用信息返回错误，入参appCode：{}, resp：{}", appCode, JsonUtils.objectToString(respEntity));
                return appMappingMap;
            }
            List<AppMappingsDTO> appMappingsDTOList = respEntity.getBody().getData();
            //如果返回的应用为空或者 应用不是钉钉平台的则返回空
            if(CollectionUtils.isEmpty(appMappingsDTOList)){
                return appMappingMap;
            }
            //取出钉钉平台的应用
            List<AppMappingsDTO> ddAppMappingsList = appMappingsDTOList.stream().filter(appMappings -> appMappings.getPlatform().equals(AppMappingsDTO.PLATFORM_DINGDING)).collect(Collectors.toList());
            if(CollectionUtils.isEmpty(ddAppMappingsList)){
                return appMappingMap;
            }
            AppMappingsDTO appMappingsDTO=ddAppMappingsList.get(0);
            appMappingMap= appMappingsDTO.getDatas().stream().collect(Collectors.toMap(AppMappingsDatasDTO -> AppMappingsDatasDTO.getKey() , part -> part.getValue()));
        } catch (BusinessException ex) {
            log.error("请求CAM获取应用信息报错，入参appCode：{}, ex：{}", appCode, ex);
        }
        return appMappingMap;
    }
}
