package com.digiwin.athena.atmc.http.restful.eoc.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class EocUserDeptDTO {
    private int code;
    private String message;
    private boolean success;
    private EocUserDeptDataDTO data;


    @Data
    public static class EocUserDeptDataDTO{

        private Integer total;

        private List<EocUserDept> list;

    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class EocUserDept {
        private Long sid;

        /**
         * 必有字段  备注：员工id
         */
        private String id;

        /**
         * 必有字段  备注：员工名称
         */
        private String name;

        private String email;

        private Boolean status;

        private String userId;

        private String userName;

        private List<EocDept> depts;

        private List<Map> duties;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class EocDept {
        private Long sid;

        /**
         * 部门id
         */
        private String id;

        private String name;

        private  String corpId;

        private String corpName;

        private Boolean mainDept;

        /**
         * 员工层级sid
         */
        private Long levelSid;

        private String levelId;

        /**
         * 直属主管id
         */
        private String directorId;

        private String directorName;

        /**
         * 部门主管id
         */
        private String deptDirectorId;

        private String deptDirectorName;

    }
}
