package com.digiwin.athena.atmc.http.restful.iam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang.StringUtils;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class BizUnitInfoDTO {
    /**
     * 公司id
     */
    private String companyId;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 工厂id
     */
    private String factoryId;

    /**
     * 工厂名称
     */
    private String factoryName;

    @JsonIgnore
    public String getEocCode() {
        if (StringUtils.isBlank(companyId)) {
            return null;
        } else {
            return StringUtils.isNotBlank(factoryId) ? companyId + "-" + factoryId : companyId;
        }
    }

    @JsonIgnore
    public String getEocName() {
        if (StringUtils.isBlank(companyName)) {
            return null;
        } else {
            return StringUtils.isNotBlank(factoryName) ? companyName + "-" + factoryName : companyName;
        }
    }

    @JsonIgnore
    public Integer getEocType() {
        if (StringUtils.isBlank(companyId)) {
            return BizUnitTypeEnum.UNKNOWN.getType();
        } else {
            return StringUtils.isNotBlank(factoryId) ? BizUnitTypeEnum.FACTORY.getType() : BizUnitTypeEnum.COMPANY.getType();
        }
    }
}
