package com.digiwin.athena.atmc.http.restful.im.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

/**
 * TeamMemberInfoDTO Description
 *
 * @author majianfu
 * @date 2021/7/10
 * @since
 */
@Data
public class TeamMemberInfoDTO {
    /**
     * 租户SID
     */
    private Long tenantSid;

    /**
     * 群成员账号类型，0：员工编号，1：鼎捷云账号
     */
    private Integer type;

    /**
     * 员工编号
     */
    private String eocId;

    /**
     * 鼎捷云账号
     */
    private String uniqueId;

    private Integer ifOwner;

    /**
     * 是否为外部用户，0：内部用户，1：外部用户
     */
    private Integer ifExternal;

    @JsonIgnore
    public boolean isExternal() {
        return 1 == ifExternal;
    }
}
