package com.digiwin.athena.atmc.http.restful.ptm.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Map;

/**
 * PTM 活动详情数据(activity表记录)
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PtmActivityRecordDTO {
    private Long id;
    private Long taskId;
    private Long projectId;
    private Long projectCardId;

    private String activityName;
    private String signReason;
    private Integer signType;
    private Map informer;
    private Integer state;
    private Integer subState;
    private String bpmnType;

    /**
     * 无用，需要从ptm_task表获取，这个字段目前永远是空的
     */
    private String bpmTaskUid;
    private String bpmActivityId;
    private String bpmActivityUid;
    private String bpmActivityName;
    private LocalDateTime createTime;
    private LocalDateTime closedTime;
    private String proxyToken;

    private String tenantId;
    private String createdBy;
    private LocalDateTime createdTime;
    private String updatedBy;
    private LocalDateTime updatedTime;
    private String entityState;
    private Map data;

}


