package com.digiwin.athena.atmc.http.restful.ptm.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 获取PTM执行人
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PtmAgentPerformerDTO {

    /**
     * 任务、待办的id
     */
    private long backlogId;

    /**
     * 任务、待办的执行人类型。如果是合并任务，取最后一个workitem的信息。
     * 0-原执行人执行
     * 1-代理人执行
     * 2-辅助执行者执行
     * 998-服务授权代理人执行
     * 999-外部使用、超级管理员
     */
    private Integer performerType;

    /**
     * 任务、待办的类型
     */
    private String performerId;

    /**
     * 任务的执行人
     */
    private String performerName;

    /**
     * 当performerType不为0时表示的真正执行人。可能没有，可能为null
     */
    private String agentPerformerId;

    /**
     * 当performerType不为0时表示的真正执行人名称。可能没有，可能为null
     */
    private String agentPerformerName;



}
