package com.digiwin.athena.atmc.http.restful.ptm.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import net.sf.json.JSONObject;

import java.time.LocalDateTime;
import java.util.Map;

/**
 * PTM 项目卡详情数据(project_card表记录)
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PtmProjectCardRecordDTO {

    private Long id;

    private String projectDefCode;
    private String projectDefName;

    /**
     * 格式："{"zh_CN":"xxx", "zh_TW": "xxxxx", "en_US": "xxxxxx"}"
     */
    private String projectDefWithName;

    private String projectDefPattern;
    private String targetId;
    private String targetName;
    private String projectName;

    /**
     * 格式："{"zh_CN":"xxx", "zh_TW": "xxxxx", "en_US": "xxxxxx"}"
     */
    private String projectWithName;

    private JSONObject businessUnit;
    private Integer state;
    private String personInCharge;
    private String personInChargeName;
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private Map mergeData;
    private String sourceIds;
    private String sourceName;
    private String remark;
    private Boolean hidden;
    private Boolean changedFlag;
    private Boolean completedReport;
    private LocalDateTime createTime;
    private LocalDateTime closedTime;
    private String engine;
    private String tenantId;
    private LocalDateTime createdTime;
    private LocalDateTime updatedTime;
    private Long projectCardId;
    private String sourceEntityName;
    private String processSerialNumber;
    private Integer subState;

}
