package com.digiwin.athena.atmc.http.restful.ptm.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * PTM 项目卡 路线对象
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PtmProjectCardRouteDTO {

    private Long projectId;

    private Long projectCardId;

    private Integer emergency;

    private List<RouteDTO> routes;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class RouteDTO {
        private Long id;
        private String routeName;
        private String pass;
        private Integer routeOrder;
        private Integer selected;
        private Integer branchIndex;
        private Long projectId;
        private Long projectCardId;
        private List<RouteActivitylDTO> activities;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class RouteActivitylDTO {

        private String id;
        private String name;
        private String parent;
        private String pass;
        private String description;
        private Integer finishedCount;
        private Integer noBeginCount;
        private Integer executeCount;
        private Integer overdueFinishedCount;
        private Boolean overdue;
        private Boolean exception;
        private Boolean milestone;
        private Integer state;
        private Boolean forecastActivity;
        private Boolean actionDefined;
        private Boolean executeType;

    }
}
