package com.digiwin.athena.atmc.http.restful.ptm.model;

import lombok.Data;

import java.time.LocalDateTime;

/**
 * PtmBacklogItemDTO Description
 *
 * @author xusijia
 * @date 2023/3/29
 * @since
 */
@Data
public class PtmRessignTrace {
    /**
     * 转派类型，0-任务转派；1-项目转派
     */
    private Integer category;

    /**
     * 来源ID，根据转派类型，可能是backlog.id，也可能是task.id
     */
    private Long sourceId;

    /**
     * 操作人ID
     */
    private String operatorId;

    /**
     * 操作人name
     */
    private String operatorName;

    /**
     * 原执行人Id
     */
    private String fromPerformerId;

    /**
     * 原执行人name
     */
    private String fromPerformerName;

    /**
     * 新执行人id
     */
    private String toPerformerId;

    /**
     * 新执行人name
     */
    private String toPerformerName;

    /**
     * 转派意见
     */
    private String comment;

    /**
     * 转派时间
     */
    private LocalDateTime reassignDate;
}
