package com.digiwin.athena.atmc.http.restful.smartdata;


import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.http.domain.misc.DemoCreateDTO;
import com.digiwin.athena.atmc.http.domain.misc.DemoItemResultDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmDataFootPrintDTO;

import java.util.List;
import java.util.Map;

public interface SmartDataService {

    /**
     * 清除指定租户的数据足迹
     * @param tenantId
     */
    Map clearDataByTenantId(String tenantId);

    /**
     * 预置指定租户的数据足迹
     * @param tenantId
     * @return
     */
    Map presetDataByTenantId(String tenantId);

    /**
     * 清除数据一致性数据
     *
     * @param user
     * @param instanceId   任务实例id
     * @param activityCode 模板id
     * @param entityName
     * @param eocMap
     * @param bkList
     * @return
     */
    Object clearComparisonData(AuthoredUser user, String instanceId, String activityCode, String entityName, Map<String, String> eocMap, List<Map> bkList);

    /**
     * 查询数据轨迹
     * @param taskCode
     * @param bk
     * @return
     */
    PtmDataFootPrintDTO queryByActTmpId(String taskCode, Map<String,Object> bk);

    /**
     * 录制数据
     * @param tenantId
     * @param baseDate
     * @return
     */
    DemoItemResultDTO smartDataRecordData(String tenantId, String baseDate);

    /**
     * 删除数据
     * @return
     */
    DemoItemResultDTO smartDataDeleteData(String tenantId);

    /**
     * 预置数据
     * @param dto
     * @return
     */
    DemoItemResultDTO smartDataCreateData(DemoCreateDTO dto);

    /**
     * 删除SD 数据对比
     * @param tenantId  租户id
     * @param type  task/project
     * @param instanceIds
     */
    void deleteDataComparison(String tenantId, String type, List<String> instanceIds);
}
