package com.digiwin.athena.atmc.http.restful.thememap.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;

/**
 * TmAppExpireChangeComponentDTO Description
 *
 * @author majianfu
 * @date 2022/8/22
 * @since
 */
@Data
public class TmAppExpireChangeComponentDTO {
    /**
     * 租户ID
     */
    private String tenantId;

    /**
     * 事件类型，renew:租户续约  expire：刚过期  clean：60天缓冲期过后
     */
    private String eventType;

    /**
     * 应用编号
     */
    private String appCode;

    /**
     * 需要查询的组件列表.
     * 项目 Project, 任务 Task, 基础资料 BaseDataEntry, 报表 Report
     */
    private List<String> component;

    /**
     * 项目列表
     */
    @JsonProperty("Project")
    private List<String> project;

    /**
     * 任务列表
     */
    @JsonProperty("Task")
    private List<String> task;

    /**
     * 基础资料录入列表
     */
    @JsonProperty("BaseDataEntry")
    private List<String> baseDataEntry;

    /**
     * 报表列表
     */
    @JsonProperty("Report")
    private List<String> report;

    @Override
    public String toString() {
        return tenantId + "-" + appCode + "-" + eventType
                + "-Project" + (CollectionUtils.isNotEmpty(project) ? project.toString() : "[]")
                + "-Task" + (CollectionUtils.isNotEmpty(task) ? task.toString() : "[]")
                + "-BaseDataEntry" + (CollectionUtils.isNotEmpty(baseDataEntry) ? baseDataEntry.toString() : "[]")
                + "-Report" + (CollectionUtils.isNotEmpty(report) ? report.toString() : "[]");
    }
}
