package com.digiwin.athena.atmc.http.restful.thememap.model;

import com.digiwin.athena.atmc.http.domain.bpm.TmRelatedUserDTO;
import lombok.Data;
import net.sf.json.JSONObject;

import java.util.List;
import java.util.Map;

@Data
public class TmTaskDefineResponseDTO {

    /**
     * 来源单据名称
     */
    private Object sourceName;

    /**
     * dueDate名称
     */
    private Object dueDateName;

    /**
     * 任务Id
     */
    private String taskId;

    /**
     * 任务名称
     */
    private Object taskName;

    /**
     * 任务类型
     */
    private String type;

    /**
     * 紧急度
     */
    private Integer emergency;

    /**
     * 流程定义ID
     */
    private String processId;

    /**
     * 任务目标ID
     */
    private String taskTargetId;

    /**
     * 任务目标名称
     */
    private Object taskTargetName;

    /**
     * 任务完成后是否要发送报告
     */
    private Boolean completedReport;

    /**
     * 时距定义，可能为null
     */
    private TmTaskDueDateTimeDistanceDTO dueDateTimeDistance;

    /**
     * 时距定义，可能为null，但dueDateTimeDistance和dataTimeDistance不可能同时存在
     */
    private TmTaskDueDateTimeDistanceDTO dataTimeDistance;

    /**
     * 项目的来源实体名称
     */
    private String sourceEntityName;

    /**
     * 查询项目来源变更单号详情的Action
     */
    private JSONObject sourceDetailAction;

    /**
     * 项目是否合并,默认应该为true
     */
    private Boolean merge;

    /**
     * 项目是否合并字段
     */
    private List<String> mergeFields;

    /**
     * 项目的pattern，
     * 目前只有唯一值business，表示该项目卡的呈现的数据来自业务数据
     * 为空或activity，表示按照之前的逻辑
     */
    private String pattern;

    /**
     * 项目卡的显示方式定义
     */
    private Map pages;

    /**
     * 任务可转派人员定义，没有定义表示可以转派给任意人员
     *
     * 冲刺5开始，不再使用，请使用assignConfig
     */
    private TmUserDTO assignTo;

    /**
     * 是否可以转派
     * 为null或true，或没有指定，都表示可以转派
     * 为false表示不可以转派
     *
     * 冲刺5开始，不再使用，请使用assignConfig
     */
    private Boolean assignAble = true;

    /**
     * 项目卡排序定义
     */
    private TmTaskGroupSettingDTO groupSetting;

    private TmRelatedUserDTO relatedUsers;

    /**
     * 为true时表示不显示项目卡。
     * 有些项目是特殊项目，不需要向用户展示。
     */
    private Boolean daemon;

    /**
     * 存储知识图谱传过来的taskcode
     */
    private List<TmTaskCode> phases;

    /**
     * 转派配置。同时兼容 assignAble 和 assignTo
     */
    private TmAssignConfigDTO assignConfig;

    @Data
    public static class TmTaskCode{

        private String code;

        private String name;

        /**
         * invokeProject:发起新项目
         */
        private String type;

        private List<String> taskCodes;

//        private List<TmTask> tasks;
    }
//
//    @Data
//    public static class TmTask{
//        private String code;
//        private boolean visible;
//    }
    /**
     * 任务名称键值对
     */
    private Map taskNames;

    /**
     * 附加数据<br>
     * action  项目卡的打开方式。没有表示平台打开。
     *      operation：customize 表示客制处理
     *      name：唯一表示动作，建议应用名称-项目code-其他内容
     *          {
     *             "operation": "customize",
     *             "name": "应用-项目名称-其他内容"
     *         }
     */
    private Map config;

}
